/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.connector.HttpResponseBase;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardWrapperFacade;
import org.apache.catalina.core.StandardWrapperValve;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.InstanceSupport;

public final class StandardWrapper
extends ContainerBase
implements ServletConfig,
Wrapper {
    private long available = 0L;
    private int countAllocated = 0;
    private int debug = 0;
    private StandardWrapperFacade facade = new StandardWrapperFacade(this);
    private static final String info = "org.apache.catalina.core.StandardWrapper/1.0";
    private Servlet instance = null;
    private int maxInstances = 20;
    private int nInstances = 0;
    private Stack instancePool = null;
    private InstanceSupport instanceSupport = new InstanceSupport(this);
    private String jspFile = null;
    private int loadOnStartup = -1;
    private HashMap parameters = new HashMap();
    private HashMap references = new HashMap();
    private String runAs = null;
    private String servletClass = null;
    private boolean singleThreadModel = false;
    private boolean unloading = false;

    public StandardWrapper() {
        this.pipeline.setBasic(new StandardWrapperValve());
    }

    public long getAvailable() {
        return this.available;
    }

    public void setAvailable(long l) {
        long l2 = this.available;
        this.available = l > System.currentTimeMillis() ? l : 0L;
        this.support.firePropertyChange("available", new Long(l2), new Long(this.available));
    }

    public int getCountAllocated() {
        return this.countAllocated;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        int n2 = this.debug;
        this.debug = n;
        this.support.firePropertyChange("debug", new Integer(n2), new Long(this.debug));
    }

    public String getInfo() {
        return info;
    }

    public InstanceSupport getInstanceSupport() {
        return this.instanceSupport;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public void setJspFile(String string) {
        String string2 = this.jspFile;
        this.jspFile = string;
        this.support.firePropertyChange("jspFile", string2, this.jspFile);
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(int n) {
        int n2 = this.loadOnStartup;
        this.loadOnStartup = n;
        this.support.firePropertyChange("loadOnStartup", new Integer(n2), new Integer(this.loadOnStartup));
    }

    public void setLoadOnStartupString(String string) {
        try {
            this.setLoadOnStartup(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            this.setLoadOnStartup(0);
        }
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public void setMaxInstances(int n) {
        int n2 = this.maxInstances;
        this.maxInstances = n;
        this.support.firePropertyChange("maxInstances", n2, this.maxInstances);
    }

    public void setParent(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardWrapper.notContext"));
        }
        super.setParent(container);
    }

    public String getRunAs() {
        return this.runAs;
    }

    public void setRunAs(String string) {
        String string2 = this.runAs;
        this.runAs = string;
        this.support.firePropertyChange("runAs", string2, this.runAs);
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public void setServletClass(String string) {
        String string2 = this.servletClass;
        this.servletClass = string;
        this.support.firePropertyChange("servletClass", string2, this.servletClass);
    }

    public void setServletName(String string) {
        this.setName(string);
    }

    public boolean isSingleThreadModel() {
        try {
            this.loadServlet();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.singleThreadModel;
    }

    public boolean isUnavailable() {
        if (this.available == 0L) {
            return false;
        }
        if (this.available <= System.currentTimeMillis()) {
            this.available = 0L;
            return false;
        }
        return true;
    }

    public void addChild(Container container) {
        throw new IllegalStateException(sm.getString("standardWrapper.notChild"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitParameter(String string, String string2) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(string, string2);
        }
        this.fireContainerEvent("addInitParameter", string);
    }

    public void addInstanceListener(InstanceListener instanceListener) {
        this.instanceSupport.addInstanceListener(instanceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecurityReference(String string, String string2) {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            this.references.put(string, string2);
        }
        this.fireContainerEvent("addSecurityReference", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet allocate() throws ServletException {
        Object object;
        if (this.debug >= 1) {
            this.log("Allocating an instance");
        }
        if (this.unloading) {
            throw new ServletException(sm.getString("standardWrapper.unloading", this.getName()));
        }
        if (!this.singleThreadModel) {
            if (this.instance == null) {
                object = this;
                synchronized (object) {
                    if (this.instance == null) {
                        try {
                            this.instance = this.loadServlet();
                        }
                        catch (ServletException servletException) {
                            throw servletException;
                        }
                        catch (Throwable throwable) {
                            throw new ServletException(sm.getString("standardWrapper.allocate"), throwable);
                        }
                    }
                }
            }
            if (!this.singleThreadModel) {
                if (this.debug >= 2) {
                    this.log("  Returning non-STM instance");
                }
                ++this.countAllocated;
                return this.instance;
            }
        }
        object = this.instancePool;
        synchronized (object) {
            while (this.countAllocated >= this.nInstances) {
                if (this.nInstances < this.maxInstances) {
                    try {
                        this.instancePool.push(this.loadServlet());
                        ++this.nInstances;
                        continue;
                    }
                    catch (ServletException servletException) {
                        throw servletException;
                    }
                    catch (Throwable throwable) {
                        throw new ServletException(sm.getString("standardWrapper.allocate"), throwable);
                    }
                }
                try {
                    this.instancePool.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.debug >= 2) {
                this.log("  Returning allocated STM instance");
            }
            ++this.countAllocated;
            return (Servlet)this.instancePool.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(Servlet servlet) throws ServletException {
        if (!this.singleThreadModel) {
            --this.countAllocated;
            return;
        }
        Stack stack = this.instancePool;
        synchronized (stack) {
            --this.countAllocated;
            this.instancePool.push(servlet);
            this.instancePool.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findInitParameter(String string) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return (String)this.parameters.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findInitParameters() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String[] stringArray = new String[this.parameters.size()];
            return this.parameters.keySet().toArray(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findSecurityReference(String string) {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            return (String)this.references.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findSecurityReferences() {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            String[] stringArray = new String[this.references.size()];
            return this.references.keySet().toArray(stringArray);
        }
    }

    public synchronized void load() throws ServletException {
        this.instance = this.loadServlet();
    }

    public synchronized Servlet loadServlet() throws ServletException {
        Object object;
        if (!this.singleThreadModel && this.instance != null) {
            return this.instance;
        }
        String string = this.servletClass;
        if (string == null && this.jspFile != null && (object = (Wrapper)((Context)this.getParent()).findChild("jsp")) != null) {
            string = object.getServletClass();
        }
        if (string == null) {
            this.unavailable(null);
            throw new ServletException(sm.getString("standardWrapper.notClass", this.getName()));
        }
        object = this.getLoader();
        if (object == null) {
            this.unavailable(null);
            throw new ServletException(sm.getString("standardWrapper.missingLoader", this.getName()));
        }
        ClassLoader classLoader = object.getClassLoader();
        if (this.isContainerServlet(string)) {
            classLoader = this.getClass().getClassLoader();
            this.log(sm.getString("standardWrapper.containerServlet", this.getName()));
        }
        Class<?> clazz = null;
        try {
            clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.unavailable(null);
            throw new ServletException(sm.getString("standardWrapper.missingClass", string), (Throwable)classNotFoundException);
        }
        if (clazz == null) {
            this.unavailable(null);
            throw new ServletException(sm.getString("standardWrapper.missingClass", string));
        }
        Servlet servlet = null;
        try {
            servlet = (Servlet)clazz.newInstance();
        }
        catch (ClassCastException classCastException) {
            this.unavailable(null);
            throw new ServletException(sm.getString("standardWrapper.notServlet", string), (Throwable)classCastException);
        }
        catch (Throwable throwable) {
            this.unavailable(null);
            throw new ServletException(sm.getString("standardWrapper.instantiate", string), throwable);
        }
        if (!this.isServletAllowed(servlet)) {
            throw new SecurityException(sm.getString("standardWrapper.privilegedServlet", string));
        }
        if (servlet instanceof ContainerServlet && this.isContainerServlet(string)) {
            ((ContainerServlet)servlet).setWrapper(this);
        }
        try {
            this.instanceSupport.fireInstanceEvent("beforeInit", servlet);
            servlet.init((ServletConfig)this.facade);
            if (this.loadOnStartup > 0 && this.jspFile != null) {
                HttpRequestBase httpRequestBase = new HttpRequestBase();
                HttpResponseBase httpResponseBase = new HttpResponseBase();
                httpRequestBase.setServletPath(this.jspFile);
                httpRequestBase.setQueryString("jsp_precompile=true");
                servlet.service((ServletRequest)httpRequestBase, (ServletResponse)httpResponseBase);
            }
            this.instanceSupport.fireInstanceEvent("afterInit", servlet);
        }
        catch (UnavailableException unavailableException) {
            this.instanceSupport.fireInstanceEvent("afterInit", servlet, (Throwable)unavailableException);
            this.unavailable(unavailableException);
            throw unavailableException;
        }
        catch (ServletException servletException) {
            this.instanceSupport.fireInstanceEvent("afterInit", servlet, (Throwable)servletException);
            throw servletException;
        }
        catch (Throwable throwable) {
            this.instanceSupport.fireInstanceEvent("afterInit", servlet, throwable);
            throw new ServletException(sm.getString("standardWrapper.initException", this.getName()), throwable);
        }
        this.singleThreadModel = servlet instanceof SingleThreadModel;
        if (this.singleThreadModel && this.instancePool == null) {
            this.instancePool = new Stack();
        }
        this.fireContainerEvent("load", this);
        return servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInitParameter(String string) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(string);
        }
        this.fireContainerEvent("removeInitParameter", string);
    }

    public void removeInstanceListener(InstanceListener instanceListener) {
        this.instanceSupport.removeInstanceListener(instanceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityReference(String string) {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            this.references.remove(string);
        }
        this.fireContainerEvent("removeSecurityReference", string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getParent() != null) {
            stringBuffer.append(this.getParent().toString());
            stringBuffer.append(".");
        }
        stringBuffer.append("StandardWrapper[");
        stringBuffer.append(this.getName());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void unavailable(UnavailableException unavailableException) {
        this.log(sm.getString("standardWrapper.unavailable", this.getName()), 2);
        if (unavailableException == null) {
            this.setAvailable(Long.MAX_VALUE);
        } else if (unavailableException.isPermanent()) {
            this.setAvailable(Long.MAX_VALUE);
        } else {
            int n = unavailableException.getUnavailableSeconds();
            if (n <= 0) {
                n = 60;
            }
            this.setAvailable(System.currentTimeMillis() + (long)n * 1000L);
        }
    }

    public synchronized void unload() throws ServletException {
        if (!this.singleThreadModel && this.instance == null) {
            return;
        }
        this.unloading = true;
        if (this.countAllocated > 0) {
            boolean bl = true;
            while (this.countAllocated > 0) {
                if (bl) {
                    this.log("Waiting for " + this.countAllocated + " instance(s) to be deallocated");
                    bl = false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = this.instance.getClass().getClassLoader();
        try {
            this.instanceSupport.fireInstanceEvent("beforeDestroy", this.instance);
            Thread.currentThread().setContextClassLoader(classLoader2);
            this.instance.destroy();
            this.instanceSupport.fireInstanceEvent("afterDestroy", this.instance);
        }
        catch (Throwable throwable) {
            this.instanceSupport.fireInstanceEvent("afterDestroy", this.instance, throwable);
            this.instance = null;
            this.instancePool = null;
            this.nInstances = 0;
            this.fireContainerEvent("unload", this);
            this.unloading = false;
            throw new ServletException(sm.getString("standardWrapper.destroyException", this.getName()), throwable);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        this.instance = null;
        if (this.singleThreadModel && this.instancePool != null) {
            try {
                Thread.currentThread().setContextClassLoader(classLoader2);
                while (!this.instancePool.isEmpty()) {
                    ((Servlet)this.instancePool.pop()).destroy();
                }
            }
            catch (Throwable throwable) {
                this.instancePool = null;
                this.nInstances = 0;
                this.unloading = false;
                this.fireContainerEvent("unload", this);
                throw new ServletException(sm.getString("standardWrapper.destroyException", this.getName()), throwable);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            this.instancePool = null;
            this.nInstances = 0;
        }
        this.unloading = false;
        this.fireContainerEvent("unload", this);
    }

    public String getInitParameter(String string) {
        return this.findInitParameter(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getInitParameterNames() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return new Enumerator(new ArrayList(this.parameters.keySet()));
        }
    }

    public ServletContext getServletContext() {
        if (this.parent == null) {
            return null;
        }
        if (!(this.parent instanceof Context)) {
            return null;
        }
        return ((Context)this.parent).getServletContext();
    }

    public String getServletName() {
        return this.getName();
    }

    protected void addDefaultMapper(String string) {
    }

    private boolean isContainerServlet(String string) {
        return string.startsWith("org.apache.catalina.");
    }

    private boolean isServletAllowed(Object object) {
        if (object instanceof ContainerServlet) {
            return ((Context)this.getParent()).getPrivileged() || object.getClass().getName().equals("org.apache.catalina.servlets.InvokerServlet");
        }
        return true;
    }

    protected String logName() {
        StringBuffer stringBuffer = new StringBuffer("StandardWrapper[");
        if (this.getParent() != null) {
            stringBuffer.append(this.getParent().getName());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(':');
        stringBuffer.append(this.getName());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void start() throws LifecycleException {
        super.start();
    }

    public void stop() throws LifecycleException {
        try {
            this.unload();
        }
        catch (ServletException servletException) {
            this.log(sm.getString("standardWrapper.unloadException", this.getName()), servletException);
        }
        super.stop();
    }
}

