/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.Base64;

public class BasicAuthenticator
extends AuthenticatorBase {
    private static final Base64 base64Helper = new Base64();
    private static final String info = "org.apache.catalina.authenticator.BasicAuthenticator/1.0";

    public String getInfo() {
        return info;
    }

    public boolean authenticate(HttpRequest httpRequest, HttpResponse httpResponse, LoginConfig loginConfig) throws IOException {
        String string;
        Principal principal = ((HttpServletRequest)httpRequest.getRequest()).getUserPrincipal();
        if (principal != null) {
            if (this.debug >= 1) {
                this.log("Already authenticated '" + principal.getName() + "'");
            }
            return true;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpRequest.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)httpResponse.getResponse();
        String string2 = httpRequest.getAuthorization();
        if (string2 != null) {
            string = this.parseUsername(string2);
            String string3 = this.parsePassword(string2);
            principal = this.context.getRealm().authenticate(string, string3);
            if (principal != null) {
                this.register(httpRequest, httpResponse, principal, "BASIC", string, string3);
                return true;
            }
        }
        if ((string = loginConfig.getRealmName()) == null) {
            string = httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort();
        }
        httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"" + string + "\"");
        httpServletResponse.setStatus(401);
        return false;
    }

    private String parseUsername(String string) {
        if (string == null) {
            return null;
        }
        if (!string.toLowerCase().startsWith("basic ")) {
            return null;
        }
        string = string.substring(6).trim();
        String string2 = new String(Base64.decode(string.getBytes()));
        int n = string2.indexOf(58);
        if (n < 0) {
            return null;
        }
        String string3 = string2.substring(0, n).trim();
        return string3;
    }

    private String parsePassword(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("Basic ")) {
            return null;
        }
        string = string.substring(6).trim();
        String string2 = new String(Base64.decode(string.getBytes()));
        int n = string2.indexOf(58);
        if (n < 0) {
            return null;
        }
        String string3 = string2.substring(n + 1).trim();
        return string3;
    }
}

