/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.iplanet.ias.security.auth.realm.certificate.CertificateRealm;
import com.iplanet.ias.security.auth.realm.webcore.NativeRealm;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.logging.LogDomains;
import com.sun.web.security.WebPrincipal;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.realm.RealmBase;

public class RealmAdapter
extends RealmBase {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static final String name = "S1WS-RealmAdapter";
    private RoleMapper mapper = null;
    private String realmName = null;
    private boolean isNative = false;

    public RealmAdapter(RoleMapper roleMapper) {
        this.mapper = roleMapper;
    }

    public boolean hasRole(Principal principal, String string) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Checking if principal:" + principal + " has role:" + string + " in realm: " + this.realmName);
        }
        return this.mapper.hasRole(principal, string, this.realmName);
    }

    public Principal authenticate(String string, String string2) {
        try {
            LoginContextDriver.login(string, string2, this.realmName);
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Web login failed: " + exception.getMessage());
            }
            return null;
        }
        return new WebPrincipal(string, string2);
    }

    public Principal authenticate(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.finest("Web login failed: No client certificate available for client-cert authentication.");
            }
            return null;
        }
        try {
            LoginContextDriver.login(x509CertificateArray, this.realmName);
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Web login failed: " + exception.getMessage());
            }
            return null;
        }
        return new WebPrincipal(x509CertificateArray);
    }

    public Principal getAlternatePrincipal(HttpRequest httpRequest) {
        if (!this.validateAlternateRequest(httpRequest)) {
            return null;
        }
        HttpRequestBase httpRequestBase = (HttpRequestBase)httpRequest;
        Principal principal = httpRequestBase.getAlternatePrincipal();
        return principal;
    }

    public String getAlternateAuthType(HttpRequest httpRequest) {
        if (!this.validateAlternateRequest(httpRequest)) {
            return null;
        }
        HttpRequestBase httpRequestBase = (HttpRequestBase)httpRequest;
        String string = httpRequestBase.getAlternateAuthType();
        return string;
    }

    private boolean validateAlternateRequest(HttpRequest httpRequest) {
        if (!this.isNative || httpRequest == null) {
            return false;
        }
        return httpRequest instanceof HttpRequestBase;
    }

    public void setRealmName(String string, String string2) {
        Realm realm = Realm.getInstance(string);
        this.realmName = "CLIENT-CERT".equals(string2) ? (realm != null && realm instanceof CertificateRealm ? string : ((realm = Realm.getDefaultInstance()) instanceof CertificateRealm ? realm.getName() : "internal-cert-realm")) : (realm == null ? Realm.getDefaultRealm() : string);
        _logger.finest("Realm name has been set to: " + this.realmName);
        realm = Realm.getInstance(this.realmName);
        if (realm instanceof NativeRealm) {
            this.isNative = true;
            _logger.finest("The realm " + this.realmName + " is a NativeRealm.");
        }
    }

    public String getRealmName() {
        return this.realmName;
    }

    protected String getPassword(String string) {
        throw new IllegalStateException("Should not reach here.");
    }

    protected Principal getPrincipal(String string) {
        throw new IllegalStateException("Should not reach here.");
    }

    protected String getName() {
        return name;
    }
}

