/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Realm
implements Comparable {
    private static Logger _logger = null;
    private static LocalStringManagerImpl localStrings;
    private static Hashtable loadedRealms;
    private String myName;
    private static final String JAAS_CONTEXT_PARAM = "jaas-context";
    private static String defaultRealmName;
    private static final String RI_DEFAULT = "default";
    public static final String INTERNAL_CERTREALM = "internal-cert-realm";
    public static final String INTERNAL_CERTREALMCLASS = "com.iplanet.ias.security.auth.realm.certificate.CertificateRealm";
    private Properties ctxProps = new Properties();

    public final String getName() {
        return this.myName;
    }

    protected final void setName(String string) {
        if (this.myName != null) {
            return;
        }
        this.myName = string;
    }

    public String toString() {
        return this.myName;
    }

    public int compareTo(Object object) {
        if (!(object instanceof Realm)) {
            return 1;
        }
        Realm realm = (Realm)object;
        String string = realm.getAuthType();
        int n = this.getAuthType().compareTo(string);
        if (n != 0) {
            return n;
        }
        string = realm.getName();
        return this.getName().compareTo(string);
    }

    public static Realm instantiate(String string, String string2, Properties properties) throws BadRealmException {
        return Realm.doInstantiate(string, string2, properties);
    }

    private static Realm doInstantiate(String string, String string2, Properties properties) throws BadRealmException {
        try {
            Class<?> clazz = Class.forName(string2);
            Object obj = clazz.newInstance();
            Realm realm = (Realm)obj;
            realm.setName(string);
            realm.init(properties);
            loadedRealms.put(string, realm);
            return realm;
        }
        catch (Exception exception) {
            throw new BadRealmException(exception.toString());
        }
    }

    protected static void updateInstance(Realm realm, String string) {
        Realm realm2 = (Realm)loadedRealms.get(string);
        if (!realm2.getClass().equals(realm.getClass())) {
            throw new Error("Incompatible class " + realm.getClass() + " in replacement realm " + string);
        }
        realm.ctxProps = realm2.ctxProps;
        loadedRealms.put(string, realm);
    }

    public static Realm getDefaultInstance() {
        return Realm.getInstance(defaultRealmName);
    }

    public static String getDefaultRealm() {
        return defaultRealmName;
    }

    public static void setDefaultRealm(String string) {
        defaultRealmName = string;
    }

    public void setProperty(String string, String string2) {
        this.ctxProps.setProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.ctxProps.getProperty(string);
    }

    public String getJAASContext() {
        return this.ctxProps.getProperty(JAAS_CONTEXT_PARAM);
    }

    public static Realm getInstance(String string) {
        if (string == null) {
            return null;
        }
        Realm realm = null;
        realm = (Realm)loadedRealms.get(string);
        if (realm == null && RI_DEFAULT.equals(string)) {
            realm = (Realm)loadedRealms.get(defaultRealmName);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, " Realm: getInstance returning realm :" + realm);
        }
        return realm;
    }

    public static Enumeration getRealmNames() {
        return loadedRealms.keys();
    }

    protected Realm() {
    }

    protected void init(Properties properties) throws BadRealmException, NoSuchRealmException {
    }

    public abstract String getAuthType();

    public abstract Enumeration getUserNames() throws BadRealmException;

    public abstract User getUser(String var1) throws NoSuchUserException, BadRealmException;

    public abstract Enumeration getGroupNames() throws BadRealmException;

    public abstract Enumeration getGroupNames(String var1) throws InvalidOperationException, NoSuchUserException;

    public abstract boolean isUserInGroup(String var1, String var2) throws NoSuchUserException;

    public abstract void refresh() throws BadRealmException;

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(Realm.class);
        loadedRealms = new Hashtable();
        defaultRealmName = RI_DEFAULT;
    }
}

