/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.validation;

import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.validation.ConnectionValidator;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionValidatorByUserTable
implements ConnectionValidator {
    String validationStatement = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource");
    static boolean _isFineLevel = _logger.isLoggable(Level.FINE);
    static boolean _isFinestLevel = _logger.isLoggable(Level.FINEST);

    public ConnectionValidatorByUserTable(String string) {
        this.validationStatement = "SELECT count(*) FROM " + string;
        if (_isFinestLevel) {
            _logger.log(Level.FINEST, "resource.validation.statement", this.validationStatement);
        }
    }

    private ConnectionValidatorByUserTable() {
    }

    public boolean isValid(ResourceHandle resourceHandle) {
        if (_isFineLevel) {
            _logger.log(Level.FINE, "resource.validation.user_table", resourceHandle.getResourceSpec().getJDBCConnectionPoolResourceName());
        }
        Connection connection = (Connection)resourceHandle.getUserConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeQuery(this.validationStatement);
            statement.close();
        }
        catch (SQLException sQLException) {
            if (_isFinestLevel) {
                _logger.log(Level.FINEST, "resource.validation.failed_validation_verb", new Object[]{resourceHandle.getResourceSpec().getJDBCConnectionPoolResourceName(), sQLException});
            } else if (_isFineLevel) {
                _logger.log(Level.FINE, "resource.validation.failed_validation", resourceHandle.getResourceSpec().getJDBCConnectionPoolResourceName());
            }
            return false;
        }
        return true;
    }
}

