/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.validation;

import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.validation.ConnectionValidator;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionValidatorByMetaData
implements ConnectionValidator {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource");
    static boolean _isFineLevel = _logger.isLoggable(Level.FINE);
    static boolean _isFinestLevel = _logger.isLoggable(Level.FINEST);

    public boolean isValid(ResourceHandle resourceHandle) {
        Connection connection = (Connection)resourceHandle.getUserConnection();
        if (_isFineLevel) {
            _logger.log(Level.FINE, "resource.validation.meta_data", resourceHandle.getResourceSpec().getJDBCConnectionPoolResourceName());
        }
        try {
            connection.getMetaData();
        }
        catch (SQLException sQLException) {
            if (_isFinestLevel) {
                _logger.log(Level.FINEST, "resource.validation.failed_validation_verb", new Object[]{resourceHandle.getResourceSpec().getJDBCConnectionPoolResourceName(), sQLException});
            } else if (_isFineLevel) {
                _logger.log(Level.FINE, "resource.validation.failed_validation", resourceHandle.getResourceSpec().getJDBCConnectionPoolResourceName());
            }
            return false;
        }
        return true;
    }
}

