/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.iplanet.ias.server.ApplicationServer;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.repository.ConnectionProperty;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.JdbcConnectionPool;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.JdbcConnection;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class JdbcAllocator
implements ResourceAllocator {
    private PoolManager poolMgr;
    private ResourceSpec spec;
    private ClientSecurityInfo info;
    private DataSource _dataSource;
    private Set _allConnProperties = null;
    private Set _persistConnProperties = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource");
    static boolean _finestLevel = _logger.isLoggable(Level.FINEST);
    static boolean _warningLevel = _logger.isLoggable(Level.WARNING);
    private final String DATADIRECT_PASSWORD = "sunm";

    public JdbcAllocator(PoolManager poolManager, String string, ResourceSpec resourceSpec, ClientSecurityInfo clientSecurityInfo) throws PoolingException {
        this.poolMgr = poolManager;
        this.spec = resourceSpec;
        this.info = clientSecurityInfo;
        JdbcConnectionPool jdbcConnectionPool = ApplicationServer.getServerContext().getResourceManager().getJDBCConnectionPoolResource(string);
        try {
            this._dataSource = (DataSource)jdbcConnectionPool.createDataSource();
        }
        catch (J2EEResourceException j2EEResourceException) {
            throw new PoolingException(j2EEResourceException);
        }
        this._allConnProperties = jdbcConnectionPool.getConnectionProperties();
        if (this._allConnProperties != null) {
            Iterator iterator = this._allConnProperties.iterator();
            HashSet<ConnectionProperty> hashSet = new HashSet<ConnectionProperty>();
            while (iterator.hasNext()) {
                ConnectionProperty connectionProperty = (ConnectionProperty)iterator.next();
                if (!connectionProperty.isReset()) continue;
                hashSet.add(connectionProperty);
            }
            if (hashSet.size() > 0) {
                this._persistConnProperties = hashSet;
            }
        }
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            ResourceHandle resourceHandle = null;
            ResourcePrincipal resourcePrincipal = this.info.getPrincipal();
            String string = resourcePrincipal.getName();
            String string2 = resourcePrincipal.getPassword();
            Connection connection = resourcePrincipal.isDefault() ? this._dataSource.getConnection() : this._dataSource.getConnection(string, string2);
            this.setupDataDirect(connection);
            connection.setAutoCommit(false);
            if (this._allConnProperties != null) {
                Iterator iterator = this._allConnProperties.iterator();
                while (iterator.hasNext()) {
                    ConnectionProperty connectionProperty = (ConnectionProperty)iterator.next();
                    String string3 = connectionProperty.getName();
                    String string4 = (String)connectionProperty.getValue();
                    Utility.invokeSetMethodCaseInsensitive(connection, string3, string4);
                    if (!_finestLevel) continue;
                    Object[] objectArray = new Object[]{string3, string4};
                    _logger.log(Level.FINEST, "resource.allocator.connection_property", objectArray);
                }
            }
            resourceHandle = new ResourceHandle(connection, this.spec, this, this.info);
            return resourceHandle;
        }
        catch (Exception exception) {
            if (exception instanceof PoolingException) {
                throw (PoolingException)exception;
            }
            throw new PoolingException(exception);
        }
    }

    public void fillInResourceObjects(ResourceHandle resourceHandle) throws PoolingException {
        if (this._persistConnProperties != null) {
            Connection connection = (Connection)resourceHandle.getResource();
            Iterator iterator = this._persistConnProperties.iterator();
            try {
                while (iterator.hasNext()) {
                    ConnectionProperty connectionProperty = (ConnectionProperty)iterator.next();
                    String string = connectionProperty.getName();
                    String string2 = (String)connectionProperty.getValue();
                    Utility.invokeSetMethodCaseInsensitive(connection, string, string2);
                    if (!_finestLevel) continue;
                    Object[] objectArray = new Object[]{string, string2};
                    _logger.log(Level.FINEST, "resource.allocator.connection_property", objectArray);
                }
            }
            catch (Exception exception) {
                throw new PoolingException(exception);
            }
        }
        resourceHandle.fillInResourceObjects(new JdbcConnection(resourceHandle, this.poolMgr));
    }

    public void closeUserConnection(ResourceHandle resourceHandle) throws PoolingException {
        try {
            Connection connection = (Connection)resourceHandle.getUserConnection();
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    public void destroyResource(ResourceHandle resourceHandle) throws PoolingException {
        try {
            this.closeUserConnection(resourceHandle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Connection connection = (Connection)resourceHandle.getResource();
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    public boolean matchConnection(ResourceHandle resourceHandle) {
        return resourceHandle.getClientSecurityInfo().equals(this.info);
    }

    public boolean supportsReauthentication() {
        return false;
    }

    public void cleanup(ResourceHandle resourceHandle) throws PoolingException {
    }

    public boolean isTransactional() {
        return false;
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle resourceHandle) throws PoolingException {
        throw new IllegalStateException("getSharedConnection not supported");
    }

    private void setupDataDirect(Connection connection) throws Exception {
        block4: {
            try {
                if (connection.getClass().getName().startsWith("com.sun.sql")) {
                    Class<?> clazz = "string".getClass();
                    Method method = connection.getClass().getMethod("unlock", clazz);
                    if (method != null) {
                        method.invoke((Object)connection, "sunm");
                    }
                }
            }
            catch (Exception exception) {
                if (!_warningLevel) break block4;
                _logger.log(Level.WARNING, "resource.validation.datadirect_unlock_failed", exception.toString());
            }
        }
    }
}

