/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache.mapping;

import com.sun.appserv.web.cache.mapping.Constants;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class ValueConstraint {
    private static Logger _logger;
    private static ResourceBundle _rb;
    private String matchValue = null;
    private float minValue = Float.MIN_VALUE;
    private float maxValue = Float.MAX_VALUE;
    private int matchExpr = 1;
    private String str;
    private boolean cacheOnMatch = true;
    private boolean cacheOnMatchFailure = false;

    public ValueConstraint(String string, String string2) throws IllegalArgumentException {
        int n;
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        _rb = _logger.getResourceBundle();
        if (string2 == null || string2.equals("equals")) {
            n = 1;
        } else if (string2.equals("greater")) {
            n = 2;
            try {
                this.minValue = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = _rb.getString("cache.mapping.greaterExpRequiresNumeric");
                Object[] objectArray = new Object[]{string};
                string3 = MessageFormat.format(string3, objectArray);
                throw new IllegalArgumentException(string3);
            }
        } else if (string2.equals("lesser")) {
            n = 3;
            try {
                this.maxValue = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = _rb.getString("cache.mapping.lesserExpRequiresNumeric");
                Object[] objectArray = new Object[]{string};
                string4 = MessageFormat.format(string4, objectArray);
                throw new IllegalArgumentException(string4);
            }
        } else if (string2.equals("not-equals")) {
            n = 4;
        } else if (string2.equals("in-range")) {
            n = 5;
            this.parseRangeValue(string);
        } else {
            String string5 = _rb.getString("cache.mapping.illegalValueExpr");
            Object[] objectArray = new Object[]{string, string2};
            string5 = MessageFormat.format(string5, objectArray);
            throw new IllegalArgumentException(string5);
        }
        this.matchExpr = n;
        this.matchValue = string;
    }

    private void parseRangeValue(String string) throws IllegalArgumentException {
        float f;
        float f2;
        if (string == null || string.length() <= 2) {
            String string2 = _rb.getString("cache.mapping.illegalValueRange");
            Object[] objectArray = new Object[]{string};
            string2 = MessageFormat.format(string2, objectArray);
            throw new IllegalArgumentException(string2);
        }
        int n = string.charAt(0) == '-' ? string.indexOf(45, 1) : string.indexOf(45, 0);
        if (n == -1) {
            String string3 = _rb.getString("cache.mapping.missingRangeSep");
            Object[] objectArray = new Object[]{string};
            string3 = MessageFormat.format(string3, objectArray);
            throw new IllegalArgumentException(string3);
        }
        String string4 = string.substring(0, n).trim();
        try {
            f2 = Float.parseFloat(string4);
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = _rb.getString("cache.mapping.lowerRangeRequiresNumber");
            Object[] objectArray = new Object[]{string4};
            string5 = MessageFormat.format(string5, objectArray);
            throw new IllegalArgumentException(string5);
        }
        if (n == string.length()) {
            String string6 = _rb.getString("cache.mapping.rangeRequiresUpperBound");
            Object[] objectArray = new Object[]{string};
            string6 = MessageFormat.format(string6, objectArray);
            throw new IllegalArgumentException(string6);
        }
        String string7 = string.substring(n + 1).trim();
        try {
            f = Float.parseFloat(string7);
        }
        catch (NumberFormatException numberFormatException) {
            String string8 = _rb.getString("cache.mapping.upperRangeRequiresNumber");
            Object[] objectArray = new Object[]{string7};
            string8 = MessageFormat.format(string8, objectArray);
            throw new IllegalArgumentException(string8);
        }
        this.minValue = f2;
        this.maxValue = f;
    }

    public void setValue(String string) {
        this.matchValue = string;
    }

    public void setMinValue(float f) {
        this.minValue = f;
    }

    public void setMaxValue(float f) {
        this.maxValue = f;
    }

    public void setMatchExpr(int n) {
        this.matchExpr = n;
    }

    public void setCacheOnMatch(boolean bl) {
        this.cacheOnMatch = bl;
    }

    public void setCacheOnMatchFailure(boolean bl) {
        this.cacheOnMatchFailure = bl;
    }

    public boolean matches(Object object) {
        boolean bl = false;
        switch (this.matchExpr) {
            case 1: {
                bl = this.matchValue.equals(object);
                break;
            }
            case 4: {
                bl = !this.matchValue.equals(object);
                break;
            }
            case 2: {
                Float f = new Float(object.toString());
                bl = f.floatValue() > this.minValue;
                break;
            }
            case 3: {
                Float f = new Float(object.toString());
                bl = f.floatValue() < this.maxValue;
                break;
            }
            case 5: {
                Float f = new Float(object.toString());
                bl = f.floatValue() >= this.minValue && f.floatValue() <= this.maxValue;
            }
        }
        return bl ? this.cacheOnMatch : this.cacheOnMatchFailure;
    }

    public String toString() {
        if (this.str == null) {
            this.str = "match value = " + this.matchValue + " match expr = " + Constants.EXPR_NAMES[this.matchExpr];
        }
        return this.str;
    }

    static {
        _rb = null;
    }
}

