/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server.util;

import com.sun.appserv.BytecodePreprocessor;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreprocessorUtil {
    private static boolean _preprocessorEnabled = false;
    private static BytecodePreprocessor[] _preprocessor;
    private static Logger _logger;

    public static boolean init(String[] stringArray) {
        if (stringArray != null) {
            PreprocessorUtil.setupPreprocessor(stringArray);
        }
        return _preprocessorEnabled;
    }

    public static byte[] processClass(String string, byte[] byArray) {
        byte[] byArray2 = byArray;
        if (_preprocessorEnabled && _preprocessor != null) {
            for (int i = 0; i < _preprocessor.length; ++i) {
                byArray = _preprocessor[i].preprocess(string, byArray);
                _logger.fine("[PreprocessorUtil.processClass] Preprocessor " + i + " Processed Class: " + string);
                if (byArray != null) {
                    byArray2 = byArray;
                    continue;
                }
                _logger.log(Level.WARNING, "loader.preprocessor_preprocess_failed", new String[]{string, _preprocessor[i].getClass().getName()});
                if (i == 0) {
                    _logger.log(Level.WARNING, "loader.preprocessor_resetting_original", string);
                    continue;
                }
                _logger.log(Level.WARNING, "loader.preprocessor_resetting_last_good", string);
            }
        }
        return byArray2;
    }

    private static synchronized void setupPreprocessor(String[] stringArray) {
        if (_preprocessor != null) {
            return;
        }
        try {
            _preprocessor = new BytecodePreprocessor[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].trim();
                Class<?> clazz = Class.forName(string);
                if (clazz != null) {
                    PreprocessorUtil._preprocessor[i] = (BytecodePreprocessor)clazz.newInstance();
                    if (_preprocessor[i] instanceof BytecodePreprocessor) {
                        PreprocessorUtil._preprocessor[i] = _preprocessor[i];
                        _preprocessorEnabled = true;
                    } else {
                        _logger.log(Level.WARNING, "loader.preprocessor_invalid_type", string);
                        _logger.log(Level.WARNING, "loader.preprocessor_disabled");
                        _preprocessorEnabled = false;
                    }
                }
                if (_preprocessor[i] != null) {
                    if (_preprocessor[i].initialize(new Hashtable())) continue;
                    _logger.log(Level.WARNING, "loader.preprocessor_failed_init", string);
                    _logger.log(Level.WARNING, "loader.preprocessor_disabled");
                    _preprocessorEnabled = false;
                    continue;
                }
                _logger.log(Level.WARNING, "loader.preprocessor_failed_init", string);
                _logger.log(Level.WARNING, "loader.preprocessor_disabled");
                _preprocessorEnabled = false;
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "loader.preprocessor_setup_ex", throwable.toString());
            _logger.log(Level.WARNING, "loader.preprocessor_disabled");
            _preprocessorEnabled = false;
            return;
        }
    }

    public static boolean isPreprocessorEnabled() {
        return _preprocessorEnabled;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    }
}

