/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.session;

import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.util.Properties;

public final class SessionReaper
extends Thread {
    private int _reapInterval = 600;
    private IWSHttpSessionManager _sessionMgr;
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private volatile boolean _done;

    public SessionReaper(Properties properties, IWSHttpSessionManager iWSHttpSessionManager) {
        String string;
        if (properties != null && (string = properties.getProperty("reapInterval")) != null) {
            try {
                this._reapInterval = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this._sessionMgr = iWSHttpSessionManager;
        this._done = false;
        if (LogUtil.enableTrace) {
            LogUtil.TRACE(5, "Starting reaper for " + this._sessionMgr);
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        while (!this._done) {
            try {
                SessionReaper.sleep(this._reapInterval * 1000);
                IWSHttpSessionManager iWSHttpSessionManager = this._sessionMgr;
                synchronized (iWSHttpSessionManager) {
                    try {
                        this._sessionMgr.reaper();
                    }
                    catch (Exception exception) {
                        LogUtil.logWarning(_res.getProp("session.SessionReaper.msg_reaperException", exception));
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void shutdown() {
        if (this._done) {
            return;
        }
        if (LogUtil.enableTrace) {
            LogUtil.TRACE(5, "Stopping reaper for " + this._sessionMgr);
        }
        this._done = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (LogUtil.enableTrace) {
            LogUtil.TRACE(5, "Stopped reaper for " + this._sessionMgr);
        }
    }
}

