/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.session;

import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

class IWSHttpSession
implements HttpSession,
Serializable {
    private String _id = null;
    private String _mangledId = null;
    private long _creationTime = 0L;
    private long _lastAccessedTime = 0L;
    private long _currentAccessTime = 0L;
    private boolean _isNew = false;
    private long _maxInactiveInterval;
    private boolean _isValid = true;
    private Hashtable _values = new Hashtable();
    private int _numObjectsToBeUnbound = 0;
    private boolean _timingOut = false;
    private IWSHttpSessionManager _mgr = null;
    private ServletContext _context = null;
    private static ResUtil _res = ResUtil.getDefaultResUtil();

    public IWSHttpSession(String string, int n, IWSHttpSessionManager iWSHttpSessionManager, ServletContext servletContext) {
        this._id = string;
        if (n != 0) {
            this.setMaxInactiveInterval(n);
        } else {
            this._maxInactiveInterval = 0L;
        }
        this._mgr = iWSHttpSessionManager;
        this._context = servletContext;
        this._values = new Hashtable();
        this._lastAccessedTime = this._creationTime = System.currentTimeMillis();
        this._currentAccessTime = this._creationTime;
    }

    public long getCreationTime() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._creationTime;
    }

    public String getId() {
        return this._id;
    }

    protected final String getMangledId() {
        if (this._id == null) {
            return null;
        }
        if (this._mangledId == null) {
            this._mangledId = IWSHttpSession.getMangledString(this._id);
        }
        return this._mangledId;
    }

    protected static final String getMangledString(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            stringBuffer.setCharAt(i, '_');
        }
        return stringBuffer.toString();
    }

    public long getLastAccessedTime() {
        return this._lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        int n = this.getTimeout();
        if (n == Integer.MAX_VALUE) {
            n = -1;
        }
        return n;
    }

    protected final int getTimeout() {
        int n = (int)(this._maxInactiveInterval == Long.MAX_VALUE ? Integer.MAX_VALUE : this._maxInactiveInterval / 1000L);
        return n;
    }

    public HttpSessionContext getSessionContext() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._mgr.getContext();
    }

    public Object getAttribute(String string) {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        if (string == null) {
            throw new NullPointerException(_res.getProp("session.IWSHttpSession.msg_namevalueNull"));
        }
        return this._values.get(string);
    }

    public Object getValue(String string) {
        return this.getAttribute(string);
    }

    public Enumeration getAttributeNames() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._values.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        String[] stringArray = null;
        Hashtable hashtable = this._values;
        synchronized (hashtable) {
            stringArray = new String[this._values.size()];
            int n = 0;
            Enumeration enumeration = this._values.keys();
            while (enumeration.hasMoreElements()) {
                stringArray[n] = (String)enumeration.nextElement();
                ++n;
            }
        }
        return stringArray;
    }

    public void invalidate() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        this._mgr.deleteSession(this);
        this._isValid = false;
    }

    public boolean isNew() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._isNew;
    }

    public void setAttribute(String string, Object object) {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        if (string == null || object == null) {
            throw new NullPointerException(_res.getProp("session.IWSHttpSession.msg_namevalueNull"));
        }
        if (this._mgr.hasPersistence() && !(object instanceof Serializable)) {
            throw new IllegalArgumentException(_res.getProp("session.IWSHttpSession.msg_badAttribute", string));
        }
        Object v = this._values.remove(string);
        if (v != null) {
            this.unbindObject(string, v);
        }
        this._values.put(string, object);
        if (object instanceof HttpSessionBindingListener) {
            ++this._numObjectsToBeUnbound;
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)object;
            httpSessionBindingListener.valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public void putValue(String string, Object object) {
        this.setAttribute(string, object);
    }

    public void removeAttribute(String string) {
        if (this._isInvalid() && !this._timingOut) {
            throw new IllegalStateException();
        }
        if (string == null) {
            throw new NullPointerException(_res.getProp("session.IWSHttpSession.msg_namevalueNull"));
        }
        Object v = this._values.remove(string);
        if (v != null) {
            this.unbindObject(string, v);
        }
    }

    public void removeValue(String string) {
        this.removeAttribute(string);
    }

    public void setMaxInactiveInterval(int n) {
        this._maxInactiveInterval = n * 1000;
        if (n < 0) {
            this._maxInactiveInterval = Long.MAX_VALUE;
        } else if (n == 0) {
            this._mgr.deleteSession(this);
            this._isValid = false;
        }
    }

    protected boolean isValid() {
        return this._isValid;
    }

    protected boolean isInvalid(long l) {
        if (!this._isValid) {
            return true;
        }
        long l2 = l - this._lastAccessedTime;
        if (l2 >= this._maxInactiveInterval) {
            this._isValid = false;
            this._timingOut = true;
            return true;
        }
        return false;
    }

    protected boolean _isInvalid() {
        return this.isInvalid(System.currentTimeMillis());
    }

    protected void setNew() {
        this._isNew = true;
    }

    protected void unsetNew() {
        this._isNew = false;
    }

    protected void updateAccessTime() {
        this._lastAccessedTime = this._currentAccessTime;
        this._currentAccessTime = System.currentTimeMillis();
    }

    protected synchronized void removeAllObjects() {
        if (this._numObjectsToBeUnbound > 0) {
            Enumeration enumeration = this._values.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = this._values.get(string);
                if (v == null) continue;
                try {
                    this.unbindObject(string, v);
                }
                catch (Exception exception) {
                    LogUtil.logWarning(_res.getProp("session.IWSHttpSession.msg_UnbindError", string, (Object)LogUtil.getStackTrace(exception)));
                }
                if (this._numObjectsToBeUnbound != 0) continue;
            }
        }
        this._values = null;
    }

    private void unbindObject(String string, Object object) {
        if (object instanceof HttpSessionBindingListener) {
            --this._numObjectsToBeUnbound;
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)object;
            httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (objectOutputStream != null) {
            objectOutputStream.writeObject(this._id);
            objectOutputStream.writeLong(this._creationTime);
            objectOutputStream.writeLong(this._lastAccessedTime);
            objectOutputStream.writeLong(this._currentAccessTime);
            objectOutputStream.writeLong(this._maxInactiveInterval);
            objectOutputStream.writeObject(this._values);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream != null) {
            this._id = (String)objectInputStream.readObject();
            this._creationTime = objectInputStream.readLong();
            this._lastAccessedTime = objectInputStream.readLong();
            this._currentAccessTime = objectInputStream.readLong();
            this._maxInactiveInterval = objectInputStream.readLong();
            this._values = (Hashtable)objectInputStream.readObject();
        }
    }

    protected final void setIWSContext(IWSHttpSessionManager iWSHttpSessionManager, ServletContext servletContext) {
        this._mgr = iWSHttpSessionManager;
        this._context = servletContext;
        this._isValid = true;
    }

    public final ServletContext getServletContext() {
        return this._context;
    }

    protected void close() {
        this._values = null;
        this._mgr = null;
        this._context = null;
    }
}

