/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class ReaderInputStream
extends InputStream {
    private Reader _reader = null;
    private CharsetEncoder _charsetEncoder = null;

    public ReaderInputStream(Reader reader) {
        this._reader = reader;
    }

    public ReaderInputStream(Reader reader, String string) {
        this._reader = reader;
        Charset charset = Charset.forName(string);
        this._charsetEncoder = charset != null ? charset.newEncoder() : null;
    }

    public ReaderInputStream(Reader reader, CharsetEncoder charsetEncoder) {
        this._reader = reader;
        this._charsetEncoder = charsetEncoder;
    }

    public int read() throws IOException {
        int n = this._reader.read();
        if (n == -1) {
            return -1;
        }
        char[] cArray = new char[]{(char)n};
        if (this._charsetEncoder == null) {
            String string = new String(cArray);
            byte[] byArray = string.getBytes();
            return byArray[0];
        }
        ByteBuffer byteBuffer = this.encode(cArray);
        return byteBuffer.get(0);
    }

    private ByteBuffer encode(char[] cArray) throws IOException {
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        this._charsetEncoder.reset();
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = this._charsetEncoder.encode(charBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IOException(characterCodingException.getMessage());
        }
        return byteBuffer;
    }
}

