/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.session;

import com.iplanet.ias.web.session.IWS60GlobalSessionAdapter;
import com.iplanet.ias.web.session.IWS60SessionBase;
import com.iplanet.ias.web.session.IWS60SessionWrapper;
import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleSupport;

public class IWSHttpSessionManagerAdapter
extends ManagerBase
implements Lifecycle {
    private static final String info = "IWSHttpSessionManagerAdapter/1.0";
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private IWSHttpSessionManager _mgr = null;
    private Properties _props = new Properties();
    private int _timeout = 1800;
    private IWS60GlobalSessionAdapter _global = new IWS60GlobalSessionAdapter();
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static ResourceBundle _rb = _logger.getResourceBundle();

    public IWSHttpSessionManagerAdapter() {
        this(null, null);
    }

    public IWSHttpSessionManagerAdapter(Properties properties, Properties properties2) {
        if (properties != null) {
            this.setManagerProperties(properties);
        }
        if (properties2 != null) {
            this.setStoreProperties(properties2);
        }
    }

    public String getInfo() {
        return info;
    }

    public void add(Session session) {
    }

    public Session createSession() {
        if (!this.ensureMgr()) {
            return null;
        }
        StandardContext standardContext = (StandardContext)this.getContainer();
        HttpSession httpSession = this._mgr.createSession(this.generateSessionId(), standardContext.getServletContext());
        if (httpSession == null) {
            return null;
        }
        if (httpSession instanceof Session) {
            ((Session)httpSession).setManager(this);
            return (Session)httpSession;
        }
        IWS60SessionWrapper iWS60SessionWrapper = new IWS60SessionWrapper(this._global, this, httpSession);
        iWS60SessionWrapper.setCreationTime(httpSession.getCreationTime());
        iWS60SessionWrapper.setNew(true);
        return iWS60SessionWrapper;
    }

    public void remove(Session session) {
        if (!this.ensureMgr()) {
            return;
        }
        if (session instanceof StandardSession) {
            String string = session.getId();
            this._global.removeSession(string);
        }
        this._mgr.deleteSession((HttpSession)session);
    }

    public Session findSession(String string) throws IOException {
        if (!this.ensureMgr()) {
            return null;
        }
        StandardContext standardContext = (StandardContext)this.getContainer();
        HttpSession httpSession = this._mgr.getSession(string, standardContext.getServletContext());
        if (httpSession == null) {
            return null;
        }
        if (httpSession instanceof Session) {
            return (Session)httpSession;
        }
        return new IWS60SessionWrapper(this._global, this, httpSession);
    }

    public Session[] findSessions() {
        return null;
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void setManagerProperties(Properties properties) {
        this._props.putAll((Map<?, ?>)this.translateMgrProps(properties));
    }

    public void setStoreProperties(Properties properties) {
        this._props.putAll((Map<?, ?>)this.translateStoreProps(properties));
    }

    public int getMaxInactiveInterval() {
        return this._timeout;
    }

    public void setMaxInactiveInterval(int n) {
        this._timeout = n;
        this._props.put("timeOut", Integer.toString(n));
    }

    private void createSessionManager(String string) {
        try {
            ClassLoader classLoader = this.getContainer().getLoader().getClassLoader();
            this._mgr = (IWSHttpSessionManager)Class.forName(string, true, classLoader).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = _rb.getString("session.adapter.sessionMgrNotFound");
            Object[] objectArray = new Object[]{string};
            string2 = MessageFormat.format(string2, objectArray);
            _logger.log(Level.WARNING, string2);
            this._mgr = null;
        }
        catch (Exception exception) {
            String string3 = _rb.getString("session.adapter.sessionMgrFailure");
            Object[] objectArray = new Object[]{string, exception.toString()};
            string3 = MessageFormat.format(string3, objectArray);
            _logger.log(Level.WARNING, string3);
            this._mgr = null;
        }
    }

    public void start() throws LifecycleException {
        this.createSessionManager((String)this._props.get("classname"));
        if (!this.ensureMgr()) {
            throw new LifecycleException("Session Manager not initialized, because class not defined or couldn't be initialized.");
        }
        try {
            this._mgr.init(this._props);
        }
        catch (Exception exception) {
            String string = _rb.getString("session.adapter.sessionMgrFailure");
            Object[] objectArray = new Object[]{this._mgr.getClass().getName(), exception.toString()};
            string = MessageFormat.format(string, objectArray);
            _logger.log(Level.WARNING, string);
        }
        this._mgr.startReaper(this._props);
    }

    public void stop() throws LifecycleException {
        if (!this.ensureMgr()) {
            return;
        }
        this._mgr.close();
    }

    public void update(HttpSession httpSession) throws Exception {
        if (!this.ensureMgr()) {
            return;
        }
        Session session = (Session)httpSession;
        if (session != null && session.isValid()) {
            if (session instanceof IWS60SessionBase) {
                ((IWS60SessionBase)session).markReqEndTime();
            } else if (session instanceof IWS60SessionWrapper) {
                httpSession = ((IWS60SessionWrapper)session).getHiddenSession();
            }
            this._mgr.update(httpSession);
        }
    }

    private Properties translateMgrProps(Properties properties) {
        Properties properties2 = new Properties();
        String string = null;
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string.equalsIgnoreCase("reapIntervalSeconds")) {
                properties2.put("reapInterval", properties.get(string));
                continue;
            }
            properties2.put(string, properties.get(string));
        }
        return properties2;
    }

    private Properties translateStoreProps(Properties properties) {
        Properties properties2 = new Properties();
        String string = null;
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string.equalsIgnoreCase("classname")) {
                properties2.put("session-data-store", properties.get(string));
                continue;
            }
            if (string.equalsIgnoreCase("directory")) {
                properties2.put("session-data-dir", properties.get(string));
                continue;
            }
            if (string.equalsIgnoreCase("reapIntervalSeconds")) {
                properties2.put("reapInterval", properties.get(string));
                continue;
            }
            properties2.put(string, properties.get(string));
        }
        return properties2;
    }

    private boolean ensureMgr() {
        if (this._mgr == null) {
            String string = _rb.getString("session.adapter.nosessionmgr");
            _logger.log(Level.SEVERE, string);
            return false;
        }
        return true;
    }

    IWSHttpSessionManager getHiddenManager() {
        return this._mgr;
    }
}

