/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.connector.nsapi;

import com.iplanet.ias.web.connector.nsapi.NSAPIRequest;
import com.iplanet.ias.web.connector.nsapi.NSAPIResponse;
import com.iplanet.ias.web.util.ReaderInputStream;
import com.iplanet.ias.web.util.WriterOutputStream;
import com.sun.logging.LogDomains;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.HttpRequestFacade;
import org.apache.catalina.connector.HttpResponseFacade;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.ApplicationResponse;

public final class NSAPIConnector
implements Connector {
    private long _jniConnector = 0L;
    private int _streamSize = 0;
    protected Container _container = null;
    private int _debug = 0;
    private static final String _info = "com.iplanet.ias.web.connector.nsapi.NSAPIConnector/1.0";
    private int _redirectPort = 443;
    private boolean _secure = false;
    private boolean _isClosing = false;
    private String _charsetName = System.getProperty("com.iplanet.ias.web.connector.nsapi.charset");
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static ResourceBundle _rb = _logger.getResourceBundle();

    public void setJNIConnector(long l) {
        this._jniConnector = l;
    }

    public int getConnectionTimeout() {
        return 0;
    }

    public void setClosing() {
        this._isClosing = true;
    }

    public boolean isClosing() {
        return this._isClosing;
    }

    public void setConnectionTimeout(int n) {
    }

    public boolean isChunkingAllowed() {
        return true;
    }

    public void setAllowChunking(boolean bl) {
    }

    public String getAddress() {
        return null;
    }

    public void setAddress(String string) {
    }

    public Container getContainer() {
        return this._container;
    }

    public void setContainer(Container container) {
        this._container = container;
    }

    public int getDebug() {
        return this._debug;
    }

    public void setDebug(int n) {
        this._debug = n;
    }

    public boolean getEnableLookups() {
        return false;
    }

    public void setEnableLookups(boolean bl) {
    }

    public String getInfo() {
        return _info;
    }

    public int getRedirectPort() {
        return this._redirectPort;
    }

    public void setRedirectPort(int n) {
        this._redirectPort = n;
    }

    public String getScheme() {
        return this.jniGetScheme(this._jniConnector);
    }

    public void setScheme(String string) {
    }

    public boolean getSecure() {
        return this._secure;
    }

    public void setSecure(boolean bl) {
        this._secure = bl;
    }

    public boolean getTcpNoDelay() {
        return true;
    }

    public void setTcpNoDelay(boolean bl) {
    }

    public Request createRequest() {
        NSAPIRequest nSAPIRequest = new NSAPIRequest();
        nSAPIRequest.setConnector(this);
        return nSAPIRequest;
    }

    public Response createResponse() {
        NSAPIResponse nSAPIResponse = new NSAPIResponse();
        nSAPIResponse.setConnector(this);
        return nSAPIResponse;
    }

    public void initialize() {
    }

    public static void dispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        NSAPIConnector nSAPIConnector = NSAPIConnector.getConnector((ServletRequest)httpServletRequest);
        if (NSAPIConnector.isIncluded((ServletResponse)httpServletResponse)) {
            nSAPIConnector.include(httpServletRequest, httpServletResponse);
        } else {
            nSAPIConnector.forward(httpServletRequest, httpServletResponse);
        }
    }

    public static void dispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, ServletException {
        NSAPIConnector nSAPIConnector = NSAPIConnector.getConnector((ServletRequest)httpServletRequest);
        if (NSAPIConnector.isIncluded((ServletResponse)httpServletResponse)) {
            nSAPIConnector.include(httpServletRequest, httpServletResponse);
        } else {
            nSAPIConnector.forward(httpServletRequest, httpServletResponse, string);
        }
    }

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        OutputStream outputStream = this.getOutputStream(httpServletResponse);
        String string = null;
        String string2 = null;
        string = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
        if (string != null) {
            string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.query_string");
        } else {
            string = httpServletRequest.getRequestURI();
            string2 = httpServletRequest.getQueryString();
        }
        int n = this.jniInclude(this._jniConnector, outputStream, string, string2);
        if (n < 100 || n > 999) {
            throw new IOException(_rb.getString("nsapiConnector.nsapiError"));
        }
        httpServletResponse.setStatus(n);
        if (n == 404) {
            String string3 = MessageFormat.format(_rb.getString("nsapiConnector.httpStatus"), Integer.toString(n));
            throw new FileNotFoundException(string3);
        }
        if (n != 200) {
            String string4 = MessageFormat.format(_rb.getString("nsapiConnector.httpStatus"), Integer.toString(n));
            throw new ServletException(string4);
        }
    }

    public void forward(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.forward(httpServletRequest, httpServletResponse, null);
    }

    public void forward(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, ServletException {
        InputStream inputStream = this.getInputStream(httpServletRequest);
        OutputStream outputStream = this.getOutputStream(httpServletResponse);
        String string2 = null;
        String string3 = null;
        string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
        if (string2 != null) {
            string3 = (String)httpServletRequest.getAttribute("javax.servlet.include.query_string");
        } else {
            string2 = httpServletRequest.getRequestURI();
            string3 = httpServletRequest.getQueryString();
        }
        int n = this.jniForward(this._jniConnector, httpServletResponse, inputStream, outputStream, string2, string3, string);
        if (n < 100 || n > 999) {
            throw new IOException(_rb.getString("nsapiConnector.nsapiError"));
        }
        if (n != 200) {
            httpServletResponse.setStatus(n);
        }
    }

    public String getResponseHeader(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return this.jniGetResponseHeader(this._jniConnector, string);
    }

    public String[] getResponseHeaderNames() {
        return this.jniGetResponseHeaderNames(this._jniConnector);
    }

    public String[] getResponseHeaderValues(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return this.jniGetResponseHeaderValues(this._jniConnector, string);
    }

    public void addResponseHeader(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.jniSetResponseHeader(this._jniConnector, string, string2, false);
    }

    public boolean containsResponseHeader(String string) {
        if (string == null) {
            return false;
        }
        return this.jniGetResponseHeader(this._jniConnector, string) != null;
    }

    public void setResponseHeader(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.jniSetResponseHeader(this._jniConnector, string, string2, true);
    }

    public void setResponseHeaderBytes(String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.jniSetResponseHeaderBytes(this._jniConnector, string, byArray, true);
    }

    public void addResponseHeaderBytes(String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.jniSetResponseHeaderBytes(this._jniConnector, string, byArray, false);
    }

    void setInitialSize(int n) {
        this._streamSize = n;
    }

    int resize(int n) {
        int n2 = this._streamSize;
        if (n != this._streamSize) {
            this._streamSize = n;
            this.jniSetSize(this._jniConnector, n);
        }
        return n2;
    }

    void flush() throws IOException {
        if (this.isClosing()) {
            this.jniFinishResponse(this._jniConnector);
        } else if (this.jniFlushResponse(this._jniConnector) == -1) {
            throw new IOException(_rb.getString("nsapiConnector.jniFlushError"));
        }
    }

    int readByte() {
        return this.jniReadByte(this._jniConnector);
    }

    int read(byte[] byArray, int n, int n2) {
        return this.jniRead(this._jniConnector, byArray, n, n2);
    }

    int readLine(byte[] byArray, int n, int n2) {
        return this.jniReadLine(this._jniConnector, byArray, n, n2);
    }

    boolean skip(int n) {
        return this.jniSkip(this._jniConnector, n);
    }

    void setAllResponseFields(int n, String string, String string2, int n2, boolean bl, String[] stringArray, int n3) {
        this.jniSetAllResponseFields(this._jniConnector, n, string, string2, n2, bl, stringArray, n3);
    }

    String getCertificate(boolean bl) {
        return this.jniGetCertificate(this._jniConnector, bl);
    }

    void writeByte(byte by) throws IOException {
        if (!this.jniWriteByte(this._jniConnector, by)) {
            throw new IOException(_rb.getString("nsapiConnector.jniWriteByteError"));
        }
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0 && this.jniWrite(this._jniConnector, byArray, n, n2) != n2) {
            throw new IOException(_rb.getString("nsapiConnector.jniWriteError"));
        }
    }

    protected void recycle() {
        this._isClosing = false;
    }

    protected static NSAPIConnector getConnector(ServletRequest servletRequest) {
        while (true) {
            if (servletRequest instanceof ServletRequestWrapper) {
                servletRequest = ((ServletRequestWrapper)servletRequest).getRequest();
                continue;
            }
            if (!(servletRequest instanceof HttpRequestFacade)) break;
            servletRequest = ((HttpRequestFacade)servletRequest).getHttpRequestBase();
        }
        return (NSAPIConnector)((Request)servletRequest).getConnector();
    }

    protected static boolean isIncluded(ServletResponse servletResponse) {
        while (servletResponse != null) {
            if (servletResponse instanceof Response) {
                return ((Response)servletResponse).getIncluded();
            }
            if (servletResponse instanceof ApplicationResponse) {
                return ((ApplicationResponse)servletResponse).isIncluded();
            }
            if (servletResponse instanceof ApplicationHttpResponse) {
                return ((ApplicationHttpResponse)servletResponse).isIncluded();
            }
            if (servletResponse instanceof ServletResponseWrapper) {
                servletResponse = ((ServletResponseWrapper)servletResponse).getResponse();
                continue;
            }
            if (!(servletResponse instanceof HttpResponseFacade)) break;
            servletResponse = ((HttpResponseFacade)servletResponse).getHttpResponseBase();
        }
        return true;
    }

    OutputStream getOutputStream(HttpServletResponse httpServletResponse) throws IOException {
        Object object = null;
        try {
            object = httpServletResponse.getOutputStream();
        }
        catch (IllegalStateException illegalStateException) {
            String string = this._charsetName;
            if (string == null) {
                string = httpServletResponse.getCharacterEncoding();
            }
            object = new WriterOutputStream((Writer)httpServletResponse.getWriter(), string);
        }
        return object;
    }

    InputStream getInputStream(HttpServletRequest httpServletRequest) throws IOException {
        Object object = null;
        try {
            object = httpServletRequest.getInputStream();
        }
        catch (IllegalStateException illegalStateException) {
            String string = this._charsetName;
            if (string == null) {
                string = httpServletRequest.getCharacterEncoding();
            }
            object = new ReaderInputStream((Reader)httpServletRequest.getReader(), string);
        }
        return object;
    }

    private native void jniSetSize(long var1, int var3);

    private native int jniFlushResponse(long var1);

    private native void jniFinishResponse(long var1);

    private native int jniWrite(long var1, byte[] var3, int var4, int var5);

    private native boolean jniWriteByte(long var1, byte var3);

    private native int jniReadByte(long var1);

    private native int jniRead(long var1, byte[] var3, int var4, int var5);

    private native int jniReadLine(long var1, byte[] var3, int var4, int var5);

    private native boolean jniSkip(long var1, int var3);

    private native void jniSetAllResponseFields(long var1, int var3, String var4, String var5, int var6, boolean var7, String[] var8, int var9);

    private native String jniGetCertificate(long var1, boolean var3);

    private native int jniInclude(long var1, OutputStream var3, String var4, String var5);

    private native int jniForward(long var1, HttpServletResponse var3, InputStream var4, OutputStream var5, String var6, String var7, String var8);

    private native String jniGetScheme(long var1);

    private native String jniGetResponseHeader(long var1, String var3);

    private native String[] jniGetResponseHeaderNames(long var1);

    private native String[] jniGetResponseHeaderValues(long var1, String var3);

    private native void jniSetResponseHeader(long var1, String var3, String var4, boolean var5);

    private native void jniSetResponseHeaderBytes(long var1, String var3, byte[] var4, boolean var5);
}

