/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.config.serverbeans.Webapp;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.web.VirtualServer;
import java.io.File;

final class WebModuleConfig {
    private Webapp _wmBean = null;
    private String _name = null;
    private String _baseDir = null;
    private ClassLoader _parentLoader = null;
    private VirtualServer _parent = null;
    private boolean _isSystemDefaultContext = false;

    WebModuleConfig() {
    }

    public void setBean(Webapp webapp) {
        this._wmBean = webapp;
    }

    public Webapp getBean() {
        return this._wmBean;
    }

    public String getName() {
        if (this._name == null) {
            if (this.isSystemDefaultContext()) {
                this._name = "default-webapp";
            } else if (this._wmBean != null) {
                this._name = this._wmBean.getUri();
            }
        }
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setParent(VirtualServer virtualServer) {
        this._parent = virtualServer;
    }

    public VirtualServer getParent() {
        return this._parent;
    }

    public void setSystemDefaultContext(boolean bl) {
        this._isSystemDefaultContext = bl;
    }

    public boolean isSystemDefaultContext() {
        return this._isSystemDefaultContext;
    }

    public String getContextPath() {
        String string = null;
        if (this._wmBean != null) {
            string = this._wmBean.getUri().trim();
            if (string.length() > 0 && !string.startsWith("/")) {
                string = "/" + string;
            } else if (string.equals("/")) {
                string = "";
            }
        }
        return string;
    }

    public String getLocation() {
        String string = null;
        if (this._wmBean != null && (string = FileUtils.normalizePath(this._wmBean.getPath())).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void setParentLoader(ClassLoader classLoader) {
        this._parentLoader = classLoader;
    }

    public ClassLoader getParentLoader() {
        return this._parentLoader;
    }

    public String getWorkDir() {
        String string = null;
        if (this._baseDir != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._baseDir);
            String string2 = this._parent.getID();
            if (string2 != null) {
                stringBuffer.append(File.separator);
                stringBuffer.append(string2);
            }
            if ((string2 = this.getName()) != null) {
                stringBuffer.append(File.separator);
                stringBuffer.append(string2);
            }
            string = FileUtils.normalizePath(stringBuffer.toString());
        }
        return string;
    }

    public void setWorkDirBase(String string) {
        this._baseDir = string;
    }
}

