/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.i18n;

import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringManager {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private ResourceBundle _resourceBundle = null;
    private static final String RES_BUNDLE_NM = ".LocalStrings";
    private static final String NO_DEFAULT = "No local string defined";
    private static Hashtable managers = new Hashtable();

    private StringManager(String string) {
        try {
            String string2 = string + RES_BUNDLE_NM;
            this._resourceBundle = ResourceBundle.getBundle(string2);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iplanet_util.no_resource_bundle", exception);
        }
    }

    public static synchronized StringManager getManager(String string) {
        StringManager stringManager = (StringManager)managers.get(string);
        if (stringManager == null) {
            stringManager = new StringManager(string);
            try {
                managers.put(string, stringManager);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "iplanet_util.error_while_caching", exception);
            }
        }
        return stringManager;
    }

    public static synchronized StringManager getManager(Class clazz) {
        try {
            Package package_ = clazz.getPackage();
            if (package_ != null) {
                String string = package_.getName();
                return StringManager.getManager(string);
            }
            String string = clazz.getName();
            return StringManager.getManager(string);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iplanet_util.error_in_getMgr", exception);
            return StringManager.getManager("");
        }
    }

    public String getString(String string) {
        return this.getStringWithDefault(string, NO_DEFAULT);
    }

    public String getStringWithDefault(String string, String string2) {
        String string3 = null;
        try {
            string3 = this._resourceBundle.getString(string);
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "No local string for: " + string, exception);
        }
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public String getStringWithDefault(String string, String string2, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat(this.getStringWithDefault(string, string2));
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                objectArray[i] = "null";
                continue;
            }
            if (objectArray[i] instanceof String || objectArray[i] instanceof Number || objectArray[i] instanceof Date) continue;
            objectArray[i] = objectArray[i].toString();
        }
        String string3 = null;
        try {
            string3 = messageFormat.format(objectArray);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "iplanet_util.error_while_formating", exception);
            string3 = string2;
        }
        return string3;
    }

    public String getString(String string, Object object) {
        return this.getStringWithDefault(string, NO_DEFAULT, new Object[]{object});
    }

    public String getString(String string, Object object, Object object2) {
        return this.getStringWithDefault(string, NO_DEFAULT, new Object[]{object, object2});
    }

    public String getString(String string, Object object, Object object2, Object object3) {
        return this.getStringWithDefault(string, NO_DEFAULT, new Object[]{object, object2, object3});
    }

    public String getString(String string, Object object, Object object2, Object object3, Object object4) {
        return this.getStringWithDefault(string, NO_DEFAULT, new Object[]{object, object2, object3, object4});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        try {
            StringManager stringManager = StringManager.getManager("com.iplanet.ias.util.i18n");
            String string = stringManager.getString("test", new Integer(7), new Date(System.currentTimeMillis()), "a disturbance in the Force");
            System.out.println(string);
            System.out.println(stringManager.getString("bad"));
        }
        catch (Exception exception) {
            System.out.println("---- Error ---- ");
            exception.printStackTrace();
        }
        finally {
            long l2 = System.currentTimeMillis();
            System.out.println("Time: " + (l2 - l));
        }
    }
}

