/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.NSAPIConfigListener;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.server.ServerContextImpl;
import com.iplanet.ias.web.WebContainer;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.logging.LogDomains;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.StringManager;

public class J2EERunner
implements NSAPIConfigListener {
    private ApplicationServer _server = null;
    private String _rootDir = null;
    private String _instanceName = null;
    private static Logger _logger;
    private ClassLoader _loader = this.getClass().getClassLoader();
    private boolean _started = false;
    private static StringManager _sm;

    public J2EERunner() {
        Thread.currentThread().setContextClassLoader(this._loader);
        this._rootDir = this.getServerRoot();
        this._instanceName = this.getServerId();
    }

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.core");
        }
        return _logger;
    }

    public int confPreInit(long l, long l2) {
        Thread.currentThread().setContextClassLoader(this._loader);
        int n = 0;
        ServerContext serverContext = null;
        try {
            serverContext = this.createServerContext();
        }
        catch (ConfigException configException) {
            n = -1;
            J2EERunner.getLogger().log(Level.SEVERE, "j2eerunner.cannotCreateServerContext", configException);
        }
        if (!this._started && n == 0) {
            try {
                this._server = new ApplicationServer();
                this._server.onInitialization(serverContext);
                if (J2EERunner.getLogger().isLoggable(Level.FINE)) {
                    J2EERunner.getLogger().log(Level.FINE, "Application server configuration file: " + serverContext.getServerConfigURL());
                    J2EERunner.getLogger().log(Level.FINE, "Application Server default locale is " + Locale.getDefault());
                }
            }
            catch (Exception exception) {
                J2EERunner.getLogger().log(Level.SEVERE, "j2eerunner.initError", exception);
                n = -1;
            }
        }
        try {
            if (n == 0) {
                WebContainer.createInstance(l, serverContext);
            }
        }
        catch (Exception exception) {
            J2EERunner.getLogger().log(Level.SEVERE, "j2eerunner.initError", exception);
            n = -1;
        }
        return n;
    }

    public int confPostInit(long l, long l2) {
        Thread.currentThread().setContextClassLoader(this._loader);
        int n = 0;
        try {
            if (!this._started) {
                this._server.onStartup();
            }
            WebContainer.startInstance(l);
            this._started = true;
        }
        catch (Exception exception) {
            n = -1;
            J2EERunner.getLogger().log(Level.SEVERE, "j2eerunner.reconfigError", exception);
        }
        return n;
    }

    public void onReady() {
        try {
            this._server.onReady();
        }
        catch (Exception exception) {
            J2EERunner.getLogger().log(Level.SEVERE, "j2eerunner.reconfigError", exception);
        }
    }

    public void shutdown() {
        J2EERunner.getLogger().log(Level.INFO, "j2eerunner.shuttingdown");
        try {
            this._server.onShutdown();
            this._server.onTermination();
        }
        catch (ServerLifecycleException serverLifecycleException) {
            J2EERunner.getLogger().log(Level.SEVERE, "j2eerunner.shutdownError", serverLifecycleException);
        }
        this._server = null;
    }

    public StandardHost createVS(long l, long l2, String string, String string2) {
        Thread.currentThread().setContextClassLoader(this._loader);
        WebContainer webContainer = WebContainer.getInstance(l);
        StandardHost standardHost = null;
        if (webContainer != null) {
            standardHost = webContainer.createVS(l2, string, string2);
        }
        return standardHost;
    }

    public int destroyVS(long l, long l2) {
        return 0;
    }

    public void confPreDestroy(long l) {
    }

    public void confPostDestroy(long l) {
        try {
            WebContainer.stopInstance(l);
        }
        catch (Exception exception) {
            J2EERunner.getLogger().log(Level.SEVERE, "j2eerunner.reconfigError", exception);
        }
    }

    public static native void requestReconfiguration();

    private ServerContext createServerContext() throws ConfigException {
        String[] stringArray = new String[]{};
        ServerContextImpl serverContextImpl = new ServerContextImpl();
        serverContextImpl.setCmdLineArgs(stringArray);
        serverContextImpl.setInstallRoot(this._rootDir);
        serverContextImpl.setInstanceName(this._instanceName);
        try {
            String string = serverContextImpl.getServerConfigURL();
            ConfigContext configContext = ConfigFactory.createConfigContext(string, true, false, false);
            serverContextImpl.setConfigContext(configContext);
        }
        catch (Exception exception) {
            if (!(exception instanceof ConfigException)) {
                J2EERunner.getLogger().log(Level.SEVERE, "j2eerunner.server_context_excp", exception);
                if (_logger == null) {
                    System.err.println("Exception in creating server context");
                    exception.printStackTrace();
                }
            }
            throw new ConfigException(exception.getMessage());
        }
        return serverContextImpl;
    }

    private native String getServerId();

    private native String getServerRoot();

    static {
        System.loadLibrary("j2eeplugin");
        _logger = null;
        _sm = StringManager.getManager("com.iplanet.ias.server");
    }
}

