/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security.auth.realm.webcore;

import com.iplanet.ias.security.auth.realm.IASRealm;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;

public class NativeRealm
extends IASRealm {
    public static final String AUTH_TYPE = "S1WS-native";
    public static final String PARAM_AUTHDB = "auth-db";

    public synchronized void init(Properties properties) throws BadRealmException, NoSuchRealmException {
        String string = properties.getProperty(PARAM_AUTHDB);
        if (string == null) {
            _logger.fine("NativeRealm: auth-db= null (will use default)");
        } else {
            _logger.fine("NativeRealm: auth-db=" + string);
            this.setProperty(PARAM_AUTHDB, string);
        }
        String string2 = properties.getProperty("jaas-context");
        if (string2 == null) {
            _logger.warning("realmconfig.noctx");
            String string3 = sm.getString("nativerealm.nojaas");
            throw new BadRealmException(string3);
        }
        this.setProperty("jaas-context", string2);
        _logger.fine("NativeRealm : jaas-context=" + string2);
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public Enumeration getGroupNames(String string) throws NoSuchUserException {
        String string2 = sm.getString("nativerealm.nogroupget");
        throw new NoSuchUserException(string2);
    }

    public boolean authenticate(String string, String string2) {
        String string3 = this.getProperty(PARAM_AUTHDB);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("native auth: authenticating [" + string + "] in db [" + string3 + "]");
        }
        return NativeRealm.nativeAuth(string, string2, string3);
    }

    public boolean isUserInGroup(String string, String string2) throws NoSuchUserException {
        String string3 = this.getProperty(PARAM_AUTHDB);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("native auth: is user [" + string + "] in group [" + string2 + "] in db [" + string3 + "]?");
        }
        return NativeRealm.nativeCheckGroup(string, string2, string3);
    }

    private static native boolean nativeAuth(String var0, String var1, String var2);

    private static native boolean nativeCheckGroup(String var0, String var1, String var2);

    static {
        System.loadLibrary("j2eeplugin");
    }
}

