/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security.auth.login;

import com.iplanet.ias.security.auth.login.PasswordLoginModule;
import com.iplanet.ias.security.auth.realm.solaris.SolarisRealm;
import com.sun.enterprise.security.auth.AuthenticationStatus;
import javax.security.auth.login.LoginException;

public class SolarisLoginModule
extends PasswordLoginModule {
    protected AuthenticationStatus authenticate() throws LoginException {
        if (!(this._currentRealm instanceof SolarisRealm)) {
            String string = sm.getString("solarislm.badrealm");
            throw new LoginException(string);
        }
        SolarisRealm solarisRealm = (SolarisRealm)this._currentRealm;
        if (this._username == null || this._username.length() == 0) {
            String string = sm.getString("solarislm.nulluser");
            throw new LoginException(string);
        }
        String[] stringArray = solarisRealm.authenticate(this._username, this._password);
        if (stringArray == null) {
            String string = sm.getString("solarislm.loginfail", this._username);
            throw new LoginException(string);
        }
        this._logger.finest("Solaris login succeeded for: " + this._username);
        AuthenticationStatus authenticationStatus = this.commitAuthentication(this._username, this._password, this._currentRealm, stringArray);
        solarisRealm.setGroupNames(this._username, stringArray);
        return authenticationStatus;
    }
}

