/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.serverbeans.Authrealm;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.Security;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.server.ApplicationServer;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RealmConfig {
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void createRealms() {
        try {
            logger.fine("Initializing configured realms.");
            ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
            if (!$assertionsDisabled && configContext == null) {
                throw new AssertionError();
            }
            Server server = ServerBeansFactory.getServerBean(configContext);
            if (!$assertionsDisabled && server == null) {
                throw new AssertionError();
            }
            Security security = server.getJava().getSecurity();
            if (!$assertionsDisabled && security == null) {
                throw new AssertionError();
            }
            String string = security.getDefaultrealm();
            Authrealm[] authrealmArray = security.getAuthrealm();
            if (!$assertionsDisabled && authrealmArray == null) {
                throw new AssertionError();
            }
            String string2 = null;
            for (int i = 0; i < authrealmArray.length; ++i) {
                Authrealm authrealm = authrealmArray[i];
                String string3 = authrealm.getName();
                String string4 = authrealm.getClassname();
                if (!$assertionsDisabled && string3 == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && string4 == null) {
                    throw new AssertionError();
                }
                try {
                    ElementProperty[] elementPropertyArray = authrealm.getElementProperty();
                    Properties properties = new Properties();
                    for (int j = 0; j < elementPropertyArray.length; ++j) {
                        ElementProperty elementProperty = elementPropertyArray[j];
                        String string5 = elementProperty.getName();
                        String string6 = elementProperty.getValue();
                        properties.setProperty(string5, string6);
                    }
                    Realm.instantiate(string3, string4, properties);
                    logger.fine("Configured realm: " + string3);
                    if (string2 != null) continue;
                    string2 = string3;
                    continue;
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "realmconfig.disable", string3);
                    logger.log(Level.WARNING, "security.exception", exception);
                }
            }
            if (string2 == null) {
                logger.severe("realmconfig.nogood");
            } else {
                try {
                    Realm realm = Realm.getInstance(string);
                    if (realm == null) {
                        string = string2;
                    }
                }
                catch (Exception exception) {
                    string = string2;
                }
                Realm.setDefaultRealm(string);
                logger.log(Level.CONFIG, "realmconfig.setdefault", string);
            }
            Realm realm = Realm.instantiate("internal-cert-realm", "com.iplanet.ias.security.auth.realm.certificate.CertificateRealm", new Properties());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "realmconfig.nogood", exception);
        }
    }

    static {
        $assertionsDisabled = !RealmConfig.class.desiredAssertionStatus();
        logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

