/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.config.serverbeans;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.StaleWriteConfigException;
import com.iplanet.ias.config.serverbeans.Gc;
import com.iplanet.ias.config.serverbeans.Partition;
import com.iplanet.ias.config.serverbeans.ServerTags;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class Cache
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String DESCRIPTION = "Description";
    public static final String PARTITION = "Partition";
    public static final String GC = "Gc";

    public Cache() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public Cache(int n) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("DESCRIPTION", DESCRIPTION, 65808, String.class);
        this.createProperty("PARTITION", PARTITION, 66112, Partition.class);
        this.createAttribute(PARTITION, "partitiondir", "Partitiondir", 513, null, null);
        this.createAttribute(PARTITION, "partitionname", "Partitionname", 513, null, null);
        this.createAttribute(PARTITION, "sections", "Sections", 513, null, null);
        this.createAttribute(PARTITION, "maxsize", "Maxsize", 1, null, "100");
        this.createAttribute(PARTITION, "minspace", "Minspace", 1, null, "0");
        this.createAttribute(PARTITION, "enabled", "Enabled", 1, null, "true");
        this.createProperty("GC", GC, 66064, Gc.class);
        this.createAttribute(GC, "gchimargin", "Gchimargin", 1, null, "80");
        this.createAttribute(GC, "gclomargin", "Gclomargin", 1, null, "70");
        this.createAttribute(GC, "gcleavefsfull", "Gcleavefsfull", 1, null, "60");
        this.createAttribute(GC, "gcextramargin", "Gcextramargin", 1, null, "30");
        this.createAttribute(GC, "enabled", "Enabled", 1, null, "true");
        this.initialize(n);
    }

    void initialize(int n) {
        this.setAttributeValue(ServerTags.ENABLED, "true");
    }

    public String getDescription() {
        return (String)this.getValue(ServerTags.DESCRIPTION);
    }

    public void setDescription(String string) {
        this.setValue(ServerTags.DESCRIPTION, string);
    }

    public void setPartition(int n, Partition partition) {
        this.setValue(PARTITION, n, partition);
    }

    public Partition getPartition(int n) {
        return (Partition)this.getValue(PARTITION, n);
    }

    public void setPartition(Partition[] partitionArray) {
        this.setValue(PARTITION, partitionArray);
    }

    public Partition[] getPartition() {
        return (Partition[])this.getValues(PARTITION);
    }

    public int sizePartition() {
        return this.size(PARTITION);
    }

    public int addPartition(Partition partition) throws ConfigException {
        return this.addPartition(partition, true);
    }

    public int addPartition(Partition partition, boolean bl) throws ConfigException {
        Partition partition2 = this.getPartitionByPartitiondir(partition.getPartitiondir());
        if (partition2 != null) {
            throw new ConfigException("Partition Already Exists: cannot add duplicate");
        }
        return this.addValue(PARTITION, partition, bl);
    }

    public int removePartition(Partition partition) {
        return this.removeValue(PARTITION, partition);
    }

    public int removePartition(Partition partition, boolean bl) throws StaleWriteConfigException {
        return this.removeValue(PARTITION, partition, bl);
    }

    public Partition getPartitionByPartitiondir(String string) {
        Partition[] partitionArray = this.getPartition();
        if (partitionArray == null) {
            return null;
        }
        for (int i = 0; i < partitionArray.length; ++i) {
            if (!partitionArray[i].getAttributeValue(Common.convertName(ServerTags.PARTITIONDIR)).equals(string)) continue;
            return partitionArray[i];
        }
        return null;
    }

    public void setGc(Gc gc) {
        this.setValue(GC, gc);
    }

    public Gc getGc() {
        return (Gc)this.getValue(GC);
    }

    public boolean isEnabled() {
        return Cache.toBoolean(this.getAttributeValue(ServerTags.ENABLED));
    }

    public void setEnabled(boolean bl, boolean bl2) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ENABLED, "" + bl, bl2);
    }

    public void setEnabled(boolean bl) {
        this.setAttributeValue(ServerTags.ENABLED, "" + bl);
    }

    public String getCachedir() {
        return this.getAttributeValue(ServerTags.CACHEDIR);
    }

    public void setCachedir(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.CACHEDIR, string, bl);
    }

    public void setCachedir(String string) {
        this.setAttributeValue(ServerTags.CACHEDIR, string);
    }

    public String getCachecapacity() {
        return this.getAttributeValue(ServerTags.CACHECAPACITY);
    }

    public void setCachecapacity(String string, boolean bl) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.CACHECAPACITY, string, bl);
    }

    public void setCachecapacity(String string) {
        this.setAttributeValue(ServerTags.CACHECAPACITY, string);
    }

    protected String getRelativeXPath() {
        String string = null;
        string = "CACHE[@cachedir='" + this.getAttributeValue("cachedir") + "']";
        return string;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator beanComparator) {
        comparators.add(beanComparator);
    }

    public static void removeComparator(BeanComparator beanComparator) {
        comparators.remove(beanComparator);
    }

    public static String getDefaultAttributeValue(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(ServerTags.ENABLED)) {
            return "true";
        }
        return null;
    }

    public static String getDefaultEnabled() {
        return "true";
    }

    public void dump(StringBuffer stringBuffer, String string) {
        ConfigBean configBean;
        stringBuffer.append(string);
        stringBuffer.append("Partition[" + this.sizePartition() + "]");
        for (int i = 0; i < this.sizePartition(); ++i) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + i + ":");
            configBean = this.getPartition(i);
            if (configBean != null) {
                configBean.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(PARTITION, i, stringBuffer, string);
        }
        stringBuffer.append(string);
        stringBuffer.append(GC);
        configBean = this.getGc();
        if (configBean != null) {
            configBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(GC, 0, stringBuffer, string);
    }

    public String dumpBeanNode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Cache\n");
        this.dump(stringBuffer, "\n  ");
        return stringBuffer.toString();
    }
}

