#!/bin/sh

#    SAM-QFS_notice_begin
#
#      Solaris 2.x Sun Storage & Archiving Management File System
#
#      Copyright (c) 2005 Sun Microsystems, Inc.
#      All Rights Reserved.
#
#      Government Rights Notice
#      Use, duplication, or disclosure by the U.S. Government is
#      subject to restrictions set forth in the Sun Microsystems,
#      Inc. license agreements and as provided in DFARS 227.7202-1(a)
#      and 227.7202-3(a) (1995), DRAS 252.227-7013(c)(ii) (OCT 1988),
#      FAR 12.212(a)(1995), FAR 52.227-19, or FAR 52.227-14 (ALT III),
#      as applicable.  Sun Microsystems, Inc.
#
#    SAM-QFS_notice_end

# samcronfix.sh - Shell script to change crontab entries
# $Id: samcronfix.sh,v 1.4 2005/04/20 15:59:52 tarl Exp $
#
# Script to update crontab. Takes two arguments:
# 1) String identifying entries in crontab to be removed
# 2) Location of file containing new entry
#
#
RM=/usr/bin/rm
if [ "$1" = "" ]
then
   echo Missing old-entry argument to crontab changing script
   exit
fi

if [ ! -z "$2" ]
then
    # Remove previous entry from crontab and add new entry
    crontab -l | grep -v $1 | cat - $2 | crontab
else
    # Just remove the entry
    crontab -l | grep -v $1 | crontab
fi

# Remove temporary file which was used to pass contents of new entry
if [ ! -z "$2" ]
then
    ${RM} $2
fi
