/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.mgmt.arc;

import com.sun.netstorage.samqfs.mgmt.arc.BufDirective;
import com.sun.netstorage.samqfs.mgmt.arc.Criteria;
import com.sun.netstorage.samqfs.mgmt.arc.DrvDirective;

public class ArGlobalDirective {
    private static final long AR_GL_log_path = 1L;
    private static final long AR_GL_ar_interval = 2L;
    private static final long AR_GL_wait = 4L;
    private static final long AR_GL_scan_method = 8L;
    private static final long AR_GL_archivemeta = 16L;
    private static final long AR_GL_notify_script = 32L;
    private static final long AR_GL_scan_squash = 64L;
    private static final int SCAN_SQUASH_ON = 1;
    private BufDirective[] bufDirs;
    private BufDirective[] maxDirs;
    private BufDirective[] overflowDirs;
    private DrvDirective[] drvDirs;
    private long interval;
    private short examMethod;
    private String logFile;
    private String notifyScript;
    private boolean wait;
    private boolean arcMeta;
    private Criteria[] crit;
    private long chgFlags;
    private int options;

    private ArGlobalDirective(BufDirective[] bufDirectiveArray, BufDirective[] bufDirectiveArray2, BufDirective[] bufDirectiveArray3, DrvDirective[] drvDirectiveArray, long l, short s, String string, String string2, boolean bl, boolean bl2, Criteria[] criteriaArray, long l2, int n) {
        this.bufDirs = bufDirectiveArray;
        this.maxDirs = bufDirectiveArray2;
        this.overflowDirs = bufDirectiveArray3;
        this.drvDirs = drvDirectiveArray;
        this.interval = l;
        this.examMethod = s;
        this.logFile = string;
        this.notifyScript = string2;
        this.wait = bl;
        this.arcMeta = bl2;
        this.crit = criteriaArray;
        this.chgFlags = l2;
        this.options = n;
    }

    public ArGlobalDirective() {
        this.chgFlags = 0L;
    }

    public BufDirective[] getBufferDirectives() {
        return this.bufDirs;
    }

    public void setBufferDirectives(BufDirective[] bufDirectiveArray) {
        this.bufDirs = bufDirectiveArray;
    }

    public BufDirective[] getMaxDirectives() {
        return this.maxDirs;
    }

    public void setMaxDirectives(BufDirective[] bufDirectiveArray) {
        this.maxDirs = bufDirectiveArray;
    }

    public BufDirective[] getOverflowDirectives() {
        return this.overflowDirs;
    }

    public void setOverflowDirectives(BufDirective[] bufDirectiveArray) {
        this.overflowDirs = bufDirectiveArray;
    }

    public DrvDirective[] getDriveDirectives() {
        return this.drvDirs;
    }

    public void setDriveDirectives(DrvDirective[] drvDirectiveArray) {
        this.drvDirs = drvDirectiveArray;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long l) {
        this.interval = l;
        this.chgFlags |= 2L;
    }

    public void resetInterval() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFFDL;
    }

    public short getExamineMethod() {
        return this.examMethod;
    }

    public void setExamineMethod(short s) {
        this.examMethod = s;
        this.chgFlags |= 8L;
    }

    public void resetExamineMethod() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFF7L;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String string) {
        this.logFile = string;
        this.chgFlags |= 1L;
    }

    public void resetLogFile() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFFEL;
    }

    public String getNotifyScript() {
        return this.notifyScript;
    }

    public void setNotifyScript(String string) {
        this.notifyScript = string;
        this.chgFlags |= 0x20L;
    }

    public void resetNotifyScript() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFDFL;
    }

    public boolean getWait() {
        return this.wait;
    }

    public void setWait(boolean bl) {
        this.wait = bl;
        this.chgFlags |= 4L;
    }

    public void resetWait() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFFBL;
    }

    public boolean getArcMeta() {
        return this.arcMeta;
    }

    public void setArcMeta(boolean bl) {
        this.arcMeta = bl;
        this.chgFlags |= 0x10L;
    }

    public void resetArcMeta() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFEFL;
    }

    public Criteria[] getCriteria() {
        return this.crit;
    }

    public void setCriteria(Criteria[] criteriaArray) {
        this.crit = criteriaArray;
    }

    public boolean getScanListSquash() {
        return (this.options & 1) == 1;
    }

    public void setScanListSquash(boolean bl) {
        this.options = bl ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
        this.chgFlags |= 0x40L;
    }

    public void resetScanListSquash() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFBFL;
    }

    public String toString() {
        int n;
        String string = "wait=" + (this.wait ? "T" : "F") + ",int=" + this.interval + ",log=" + this.logFile + ",sh=" + this.notifyScript + ",arcm=" + (this.arcMeta ? "T" : "F") + ",scan_squash=" + ((this.options & 1) == 1 ? "on" : "off") + " opts:0x" + Integer.toHexString(this.options) + " [cf:0x" + Long.toHexString(this.chgFlags) + "]\n";
        for (n = 0; n < this.bufDirs.length; ++n) {
            string = string + this.bufDirs[n] + "\n";
        }
        for (n = 0; n < this.maxDirs.length; ++n) {
            string = string + this.maxDirs[n] + "\n";
        }
        for (n = 0; n < this.overflowDirs.length; ++n) {
            string = string + this.overflowDirs[n] + "\n";
        }
        for (n = 0; n < this.drvDirs.length; ++n) {
            string = string + this.drvDirs[n] + "\n";
        }
        if (this.crit != null) {
            for (n = 0; n < this.crit.length; ++n) {
                string = string + this.crit[n] + "\n";
            }
        }
        return string;
    }
}

