/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.mgmt.arc;

import com.sun.netstorage.samqfs.mgmt.arc.Copy;
import com.sun.netstorage.samqfs.mgmt.arc.Criteria;

public class ArFSDirective {
    private static final long AR_FS_log_path = 1L;
    private static final long AR_FS_fs_interval = 2L;
    private static final long AR_FS_wait = 4L;
    private static final long AR_FS_scan_method = 8L;
    private static final long AR_FS_archivemeta = 16L;
    private static final long AR_FS_scan_squash = 64L;
    private static final int SCAN_SQUASH_ON = 1;
    private String fsName;
    private Criteria[] crit;
    private String logPath;
    private long interval;
    private short examMethod;
    private boolean wait;
    private boolean arcMeta;
    private int numCopies;
    private Copy[] metadataCopies;
    private long chgFlags;
    private int options;
    public static final int EM_NOT_SET = -1;
    public static final int EM_SCAN = 1;
    public static final int EM_SCANDIRS = 2;
    public static final int EM_SCANINODES = 3;
    public static final int EM_NOSCAN = 4;

    private ArFSDirective(String string, Criteria[] criteriaArray, String string2, short s, long l, boolean bl, boolean bl2, int n, Copy[] copyArray, long l2, int n2) {
        this.fsName = string;
        this.crit = criteriaArray;
        this.logPath = string2;
        this.interval = l;
        this.examMethod = s;
        this.wait = bl;
        this.arcMeta = bl2;
        this.numCopies = n;
        this.metadataCopies = copyArray;
        this.chgFlags = l2;
        this.options = n2;
    }

    public ArFSDirective() {
        this.chgFlags = 0L;
    }

    public String getFSName() {
        return this.fsName;
    }

    public Criteria[] getCriteria() {
        return this.crit;
    }

    public void setCriteria(Criteria[] criteriaArray) {
        this.crit = criteriaArray;
    }

    public short getExamineMethod() {
        return this.examMethod;
    }

    public void setExamineMethod(short s) {
        this.examMethod = s;
        this.chgFlags |= 8L;
    }

    public void resetExamineMethod() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFF7L;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String string) {
        this.logPath = string;
        this.chgFlags |= 1L;
    }

    public void resetLogPath() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFFEL;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long l) {
        this.interval = l;
        this.chgFlags |= 2L;
    }

    public void resetInterval() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFFDL;
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean bl) {
        this.wait = bl;
        this.chgFlags |= 4L;
    }

    public void resetWait() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFFBL;
    }

    public boolean isArcMeta() {
        return this.arcMeta;
    }

    public void setArcMeta(boolean bl) {
        this.arcMeta = bl;
        this.chgFlags |= 0x10L;
    }

    public void resetArcMeta() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFEFL;
    }

    public Copy[] getMetadataCopies() {
        return this.metadataCopies;
    }

    public void setMedatataCopies(Copy[] copyArray) {
        this.metadataCopies = copyArray;
    }

    public boolean getScanListSquash() {
        return (this.options & 1) == 1;
    }

    public void setScanListSquash(boolean bl) {
        this.options = bl ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
        this.chgFlags |= 0x40L;
    }

    public void resetScanListSquash() {
        this.chgFlags &= 0xFFFFFFFFFFFFFFBFL;
    }

    public String toString() {
        int n;
        String string = this.fsName + ",log=" + (this.logPath == null ? "-" : this.logPath) + ",intv=" + this.interval + ",wait=" + (this.wait ? "T," : "F,") + ",arcm=" + (this.arcMeta ? "T," : "F,") + ",exam=" + this.examMethod + ",options:0x" + Integer.toHexString(this.options) + "," + this.numCopies + " metadata copies" + (this.numCopies == 0 ? "\n" : ":\n");
        for (n = 0; n < this.metadataCopies.length; ++n) {
            string = this.metadataCopies[n] != null ? string + " " + this.metadataCopies[n] + "\n" : string + " null\n";
        }
        for (n = 0; n < this.crit.length; ++n) {
            string = string + this.crit[n] + "\n";
        }
        return string;
    }
}

