#!/usr/bin/perl

# Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
#
# Sun Microsystems, Inc. has intellectual property rights relating to
# technology embodied in the product that is described in this document.
# In particular, and without limitation, these intellectual property rights
# may include one or more of the U.S. patents listed at
# http://www.sun.com/patents and one or more additional patents or pending
# patent applications in the U.S. and in other countries.
#
# U.S. Government Rights - Commercial software.  Government users are subject
# to the Sun Microsystems, Inc. standard license agreement and applicable
# provisions of the FAR and its supplements.
#
# Use is subject to license terms.
#
# This distribution may include materials developed by third parties.Sun,
# Sun Microsystems and  the Sun logo are trademarks or registered trademarks
# of Sun Microsystems, Inc. in the U.S. and other countries.  
#
# Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
# Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
#  la technologie incorpore dans le produit qui est dcrit dans ce document.
# En particulier, et ce sans limitation, ces droits de proprit
# intellectuelle peuvent inclure un ou plus des brevets amricains lists
#  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
# ou les applications de brevet en attente aux Etats - Unis et dans les
# autres pays.
#
# L'utilisation est soumise aux termes du contrat de licence.
#
# Cette distribution peut comprendre des composants dvelopps par des
# tierces parties.
#
# Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
# marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
# d'autres pays.

# The bulk account federation in Access Manager is achieved through couple of
# perl scripts.
# 1. amGenerateNI.pl - This script will generate random name identifiers for
# each user accounts from a service provider and an identity provider that
# have one to one mappings in a flat file separated by "|".
#
# For e.g. a flat file could like this:
#  uid=spuser1,ou=People,dc=sp,dc=com	| uid=idpuser1,ou=People,dc=idp,dc=com
#  uid=spuser2,ou=People,dc=sp,dc=com	| uid=idpuser2,ou=People,dc=idp,dc=com
#  uid=spuser3,ou=People,dc=sp,dc=com	| uid=idpuser3,ou=People,dc=idp,dc=com
#
# After running this script on the above flat file, it would generate two
# other flat files which contains user id to name identifier mappings.
#
# For e.g., the output may look like this.
#  uid=spuser1,ou=People,dc=sp,dc=com	| 1is341jv024lkw3j6pmpr0s82apqxn8a
#  uid=spuser2,ou=People,dc=sp,dc=com	| wkh34ldd88n8l54gzs4rftb34bs4837u
#  uid=spuser3,ou=People,dc=sp,dc=com	| l514znc34u34n34gf65hdg6truqh7f2x2424
#
# 2. amGenerateLDIF.pl - This script is useful if the service provider or the
# identity provider is an Access Manager. It helps in generating LDAP Vx
# based LDIF files so that they could easily uploaded to the user entries.
# In this case, it assumes that the entries are userDNs.
#
# This script will require input parameters as follows.
# amGenerateLDIF.pl <nameidmappingsfile> ServiceProviderID IdentityProviderID
#	ProviderRole
#    Where
#	 nameidmappingsfile - a file that has userid/nameid mappings.
#	 ServiceProviderID - Service ProviderID For e.g. http://www.sp1.com
#	 IdentityProviderID - Identity ProviderID For e.g. http://www.idp1.com
#	 ProviderRole - ProviderRole For e.g. IDP or SP.
#
# After running this script, it generates an LDIF file like this:
# dn: uid=spuser1,ou=People,dc=sp,dc=com
# changetype: modify
# iplanet-am-user-federation-info: |http://www.idp1.com|null|null|null|1is341jv024lkw3j6pmpr0s82apqxn8a|http://www.sp1.com|urn:liberty:iff:nameid:federated|IDPRole|Active|
# iplanet-am-user-federation-info-key: |http://www.sp1.com|1is341jv024lkw3j6pmpr0s82apqxn8a|

# dn: uid=spuser2,ou=People,dc=sp,dc=com
# changetype: modify
# iplanet-am-user-federation-info: |http://www.idp1.com|null|null|null|wkh34ldd88n8l54gzs4rftb34bs4837u|http://www.sp1.com|urn:liberty:iff:nameid:federated|IDPRole|Active|
# iplanet-am-user-federation-info-key: |http://www.sp1.com|wkh34ldd88n8l54gzs4rftb34bs4837u|

# dn: uid=spuser3,ou=People,dc=sp,dc=com
# changetype: modify
# iplanet-am-user-federation-info: |http://www.idp1.com|null|null|null|l514znc34u34n34gf65hdg6truqh7f2x2424|http://www.sp1.com|urn:liberty:iff:nameid:federated|IDPRole|Active|
# iplanet-am-user-federation-info-key: |http://www.sp1.com|l514znc34u34n34gf65hdg6truqh7f2x2424|
#
# The generated LDIF file could be loaded into the user repository using
# ldapmodify as follows.
# ldapmodify -D "cn=Directory Manager" -w 11111111 -h www.sp1.com -p 389
#		-f generatedfile.ldif
#



# This function generates an alphanumeric sequence of random identifiers. The
# uniqueness can be extended by modifying the random seed. 
sub generateRandom() {

     $length = 30;
     $rndstr = "";

     for ($i=0; $i < $length; $i++)
     {
      $value = int rand 36 ;
      if($value eq '0') {
         $rndstr = $rndstr . $value;
      } elsif($value eq '1') {
         $rndstr = $rndstr . $value;
      } elsif($value eq '2') {
         $rndstr = $rndstr . $value;
      } elsif($value eq '3') {
         $rndstr = $rndstr . $value;
      } elsif($value =~ '4') {
         $rndstr = $rndstr . $value;
      } elsif($value eq '5') {
         $rndstr = $rndstr . $value;
      } elsif($value eq '6') {
         $rndstr = $rndstr . $value;
      } elsif($value eq '7') {
         $rndstr = $rndstr . $value;
      } elsif($value eq '8') {
         $rndstr = $rndstr . $value;
      } elsif($value eq '9') {
         $rndstr = $rndstr . $value;
      } elsif($value eq '10') {
         $rndstr = $rndstr . "a";
      } elsif($value eq '11') {
         $rndstr = $rndstr . "b";
      } elsif($value eq '12') {
         $rndstr = $rndstr . "c";
      } elsif($value eq '13') {
         $rndstr = $rndstr . "d";
      } elsif($value eq '14') {
         $rndstr = $rndstr . "e";
      } elsif($value eq '15') {
         $rndstr = $rndstr . "f";
      } elsif($value eq '16') {
         $rndstr = $rndstr . "g";
      } elsif($value eq '17') {
         $rndstr = $rndstr . "h";
      } elsif($value eq '18') {
         $rndstr = $rndstr . "i";
      } elsif($value eq '19') {
         $rndstr = $rndstr . "k";
      } elsif($value eq '20') {
         $rndstr = $rndstr . "j";
      } elsif($value eq '21') {
         $rndstr = $rndstr . "l";
      } elsif($value eq '22') {
         $rndstr = $rndstr . "m";
      } elsif($value eq '23') {
         $rndstr = $rndstr . "n";
      } elsif($value eq '24') {
         $rndstr = $rndstr . "o";
      } elsif($value eq '25') {
         $rndstr = $rndstr . "p";
      } elsif($value eq '26') {
         $rndstr = $rndstr . "q";
      } elsif($value eq '27') {
         $rndstr = $rndstr . "r";
      } elsif($value eq '28') {
         $rndstr = $rndstr . "s";
      } elsif($value eq '29') {
         $rndstr = $rndstr . "t";
      } elsif($value eq '30') {
         $rndstr = $rndstr . "u";
      } elsif($value eq '31') {
         $rndstr = $rndstr . "v";
      } elsif($value eq '32') {
         $rndstr = $rndstr . "w";
      } elsif($value eq '33') {
         $rndstr = $rndstr . "x";
      } elsif($value eq '34') {
         $rndstr = $rndstr . "y";
      } elsif($value eq '35') {
         $rndstr = $rndstr . "z";
      }
    }
    return $rndstr;
   
}


# Main function starts here. This script expects a users data file which
# could possibly contain user ids or  common attributes with "|" separated
# entries. After execution of this script, it will generate two files with
# spnameidentifiers.txt and idpnameidentifiers.txt data files with a generated
# unique identifier along with their userid/common attributes. 

sub Main {

   my $fileName = $ARGV[0];

   open(USERFH, $fileName) || die("Could not open file!");
   @allusers=<USERFH>;
   close(USERFH);

   unlink 'spnameidentifiers.txt', 'idpnameidentifiers.txt';
   open (PH1, ">>spnameidentifiers.txt"); 
   print PH1 "# This is a generated file. Modify at your risk!"; 
   print PH1 "\n";
   open(PH2, ">>idpnameidentifiers.txt");
   print PH2 "# This is a generated file. Modify at your risk!"; 
   print PH2 "\n";

   foreach $line (@allusers) {
      chomp ($line);
      if(!($line =~ /^#/) && !($line =~ /^$/)) {

        ($firstuser, $seconduser)=split(/\|/, $line);
         $firstuser=~ s/(^ *)||( *$)//g;
         $seconduser=~ s/(^ *)||( *$)//g;
         $random=generateRandom();
         print PH1 "$firstuser      |  $random";
         print PH1 "\n";
         print PH2 "$seconduser     |  $random";
         print PH2 "\n";
        
      }
   }
}
 
Main;
