#!/usr/bin/perl

# Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
#
# Sun Microsystems, Inc. has intellectual property rights relating to
# technology embodied in the product that is described in this document.
# In particular, and without limitation, these intellectual property rights
# may include one or more of the U.S. patents listed at
# http://www.sun.com/patents and one or more additional patents or pending
# patent applications in the U.S. and in other countries.
#
# U.S. Government Rights - Commercial software.  Government users are subject
# to the Sun Microsystems, Inc. standard license agreement and applicable
# provisions of the FAR and its supplements.
#
# Use is subject to license terms.
#
# This distribution may include materials developed by third parties.Sun,
# Sun Microsystems and  the Sun logo are trademarks or registered trademarks
# of Sun Microsystems, Inc. in the U.S. and other countries.  
#
# Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
# Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
#  la technologie incorpore dans le produit qui est dcrit dans ce document.
# En particulier, et ce sans limitation, ces droits de proprit
# intellectuelle peuvent inclure un ou plus des brevets amricains lists
#  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
# ou les applications de brevet en attente aux Etats - Unis et dans les
# autres pays.
#
# L'utilisation est soumise aux termes du contrat de licence.
#
# Cette distribution peut comprendre des composants dvelopps par des
# tierces parties.
#
# Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
# marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
# d'autres pays.

# The bulk account federation in Access Manager is achieved through couple of
# perl scripts.
# 1. amGenerateNI.pl - This script will generate random name identifiers for
# each user accounts from a service provider and an identity provider that
# have one to one mappings in a flat file separated by "|". 
#
# For e.g. a flat file could like this:
#  uid=spuser1,ou=People,dc=sp,dc=com   | uid=idpuser1,ou=People,dc=idp,dc=com
#  uid=spuser2,ou=People,dc=sp,dc=com   | uid=idpuser2,ou=People,dc=idp,dc=com
#  uid=spuser3,ou=People,dc=sp,dc=com   | uid=idpuser3,ou=People,dc=idp,dc=com
#
# After running this script on the above flat file, it would generate two
# other flat files which contains user id to name identifier mappings. 
#
# For e.g., the output may look like this.
#  uid=spuser1,ou=People,dc=sp,dc=com   | 1is341jv024lkw3j6pmpr0s82apqxn8a
#  uid=spuser2,ou=People,dc=sp,dc=com   | wkh34ldd88n8l54gzs4rftb34bs4837u
#  uid=spuser3,ou=People,dc=sp,dc=com	| l514znc34u34n34gf65hdg6truqh7f2x2424
#
# 2. amGenerateLDIF.pl - This script is useful if the service provider or the
# identity provider is an Access Manager. It helps in generating LDAP Vx
# based LDIF files so that they could easily uploaded to the user entries. 
# In this case, it assumes that the entries are userDNs.
#
# This script will require input parameters as follows.
# generateLDIF.pl <nameidmappingsfile> ServiceProviderID IdentityProviderID
#      ProviderRole 
#    Where 
#        nameidmappingsfile - a file that has userid/nameid mappings.
#        ServiceProviderID - Service ProviderID For e.g. http://www.sp1.com
#        IdentityProviderID - Identity ProviderID For e.g. http://www.idp1.com
#        ProviderRole - ProviderRole For e.g. IDP or SP.
#
# After running this script, it generates an LDIF file like this:
# dn: uid=spuser1,ou=People,dc=sp,dc=com
# changetype: modify
# iplanet-am-user-federation-info: |http://www.idp1.com|null|null|null|1is341jv024lkw3j6pmpr0s82apqxn8a|http://www.sp1.com|urn:liberty:iff:nameid:federated|IDPRole|Active|
# iplanet-am-user-federation-info-key: |http://www.sp1.com|1is341jv024lkw3j6pmpr0s82apqxn8a|

# dn: uid=spuser2,ou=People,dc=sp,dc=com
# changetype: modify
# iplanet-am-user-federation-info: |http://www.idp1.com|null|null|null|wkh34ldd88n8l54gzs4rftb34bs4837u|http://www.sp1.com|urn:liberty:iff:nameid:federated|IDPRole|Active|
# iplanet-am-user-federation-info-key: |http://www.sp1.com|wkh34ldd88n8l54gzs4rftb34bs4837u|

# dn: uid=spuser3,ou=People,dc=sp,dc=com
# changetype: modify
# iplanet-am-user-federation-info: |http://www.idp1.com|null|null|null|l514znc34u34n34gf65hdg6truqh7f2x2424|http://www.sp1.com|urn:liberty:iff:nameid:federated|IDPRole|Active|
# iplanet-am-user-federation-info-key: |http://www.sp1.com|l514znc34u34n34gf65hdg6truqh7f2x2424|
#
# The generated LDIF file could be loaded into the user repository using
# ldapmodify as follows.
# ldapmodify -D "cn=Directory Manager" -w 11111111 -h www.sp1.com -p 389 
#            -f generatedfile.ldif 
#


sub Main {

    if(@ARGV < 4 || @ARGV > 4) {
       print "Usage: amGenerateLDIF.pl NameIDMappingFile SPProviderID, IDPProviderID, ProviderRole";
       print "\n";
       print "\n";
       print "Example Usage: amGenerateLDIF.pl provider.txt http://www.sp1.com http://www.idp1.com IDP|SP";
       print "\n";
       exit 1;
    }

    my $fileName = $ARGV[0];
    $spproviderid = $ARGV[1];
    $idpproviderid = $ARGV[2];
    $role = $ARGV[3];

    if($role ne 'IDP' && $role ne 'SP') {
       print "$role: Invalid Provider Role. Role must be either IDP or SP\n";
       exit 1;
    }

    open(NIMH, $fileName) || die("Could not open file");
    @allusers=<NIMH>;
    close(NIMH);
    

    $format="urn:liberty:iff:nameid:federated";

    foreach $line (@allusers) {
        chomp($line);

        if(!($line =~ /^#/) && !($line =~ /^$/)) {

           ($userdn, $nameidentifier)=split(/\|/, $line);

            # Remove leading-trailing spaces.
            $userdn=~ s/(^ *)||( *$)//g;
            $nameidentifier=~ s/(^ *)||( *$)//g;

            $fedkey="|$spproviderid|$nameidentifier|";

            if($role eq 'SP') {

               open(UULSP, ">>spuserdata.ldif");
               $userinfo = "|".$idpproviderid."|null|null|null|";
               $userinfo = $userinfo.$nameidentifier."|".$spproviderid."|";
               $userinfo = $userinfo.$format."|IDPRole|Active|";

               print UULSP  "dn: $userdn\n";
               print UULSP  "changetype: modify\n";
               print UULSP  "add: iplanet-am-user-federation-info\n";
               print UULSP  "iplanet-am-user-federation-info: $userinfo\n";
               print UULSP  "-\n";
               print UULSP  "add: iplanet-am-user-federation-info-key\n";
               print UULSP  "iplanet-am-user-federation-info-key: $fedkey\n";
               print UULSP  "\n";

            } elsif ($role eq 'IDP') {

               open(UULIDP, ">>idpuserdata.ldif");
               $userinfo = "|".$spproviderid."|".$nameidentifier."|";
               $userinfo = $userinfo.$spproviderid."|".$format;
               $userinfo = $userinfo."|null|null|null|SPRole|Active";

               print UULIDP "dn: $userdn\n";
               print UULIDP "changetype: modify\n";
               print UULIDP "add: iplanet-am-user-federation-info\n";
               print UULIDP "iplanet-am-user-federation-info: $userinfo\n";
               print UULIDP "-\n";
               print UULIDP  "add: iplanet-am-user-federation-info-key\n";
               print UULIDP "iplanet-am-user-federation-info-key: $fedkey\n";
               print UULIDP "\n";

            } else {
               print "Invalid Provider Role\n";
               exit 1;
            }
        }
    }
}

Main;
