/**
 * $Id: SampleRoleOperations.java,v 1.8 2005/06/24 16:54:02 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


package com.iplanet.am.samples.sdk;

import java.io.*;
import java.net.*;
import java.util.*;
import com.iplanet.sso.*;
import com.iplanet.am.sdk.*;
import com.sun.identity.authentication.internal.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class SampleRoleOperations {

    SSOToken token = null;
    private static Map scrObjMap = new HashMap();
    /**
     * This role will be used for further sample operations on the
     * same object
     */
    private static AMRole contextRole;

    public static AMStoreConnection amsc = null;
    public static SampleRoleOperations sro;

    public static void main(String args[]) {
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(new AuthPrincipal("uid=amadmin,ou=People,o=iplanet.com,o=isp"), "netscape");
            amsc = new AMStoreConnection(token);
            sro = getSampleRoleOperations(token);
            System.out.println(sro.createRole(amsc));
            System.out.println(sro.addUsertoRole());
        } catch (Exception e) {
            System.out.println("Exception Message: " + e.getMessage());
            e.printStackTrace();
        }
    }


    /**
     * Basic Constructor
     */
    public SampleRoleOperations(SSOToken token) {
        this.token = token;
        scrObjMap.put(token, this);
    }

    /* Use the same  object for multiple operations */

    public static SampleRoleOperations getSampleRoleOperations(SSOToken token) {
        SampleRoleOperations scrObj = (SampleRoleOperations)scrObjMap.get(token);
        if (scrObj == null ) {
            scrObj = new SampleRoleOperations(token);
        }
        return scrObj;
    }

  /**
   * This method will describe the SDK usage for creating a role.
   * It uses AMStoreConnection to get the organization object.
   * This method is used for command line.
   * It throws an AMException  if it's unble to create it and we throw
   * message "unable to create" to the GUI by catching the same
   */

    public String createRole(AMStoreConnection conn) {
        try {
            String roleName = "samplerole1";
            String roleDescription = "This is a Sample Role ";
            Set roleSet = new HashSet();
            roleSet.add(roleDescription);
            Map attrValMap = new HashMap();
            attrValMap.put("iplanet-am-role-description", roleSet);

            /*
             * Get the Role Object using AMStoreConnection
            */
            String orgDN = "o=iplanet.com,o=isp";
            Map roleMap = new HashMap();
            roleMap.put(roleName, attrValMap);
            AMOrganization  org = conn.getOrganization(orgDN);
            Set roles = org.createRoles(roleMap);
            Iterator iter = roles.iterator();
            contextRole = (AMRole)iter.next();
            return showCreateRoleSuccess();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
            return "Unable to create";
    }

    /**
     * This method describes the SDK usage for adding User to the Role.
     * This method is used for command line.
     */

    public String addUsertoRole() {
        try {
            /**
             * The DN for the user can be changed according to one's own DIT
             */ 
            String userDN = "uid=abcd,ou=people,o=iplanet.com,o=isp";
            Set userSet = new HashSet();
            userSet.add(userDN);
            contextRole.addUsers(userSet);
            return "Successfully added";
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return "Unable to add";
    }

  /**
   * This method will describe the SDK usage for creating a role.
   * It uses AMStoreConnection to get the organization object
   * It throws an AMException  if it's unble to create it and we throw
   * message "unable to create" to the GUI by catching the same
   */

    public String createRole(HttpServletRequest req, Set parameters, AMStoreConnection conn) {
        try {
            String roleName = "";
            String roleDescription = "";
            if (parameters.contains("rolename")) {
                roleName = req.getParameter("rolename");
            }
            if (parameters.contains("roledescription")) {
                roleDescription = req.getParameter("roledescription");
            }
            Set roleSet = new HashSet();
            roleSet.add(roleDescription);
            Map attrValMap = new HashMap();
            attrValMap.put("iplanet-am-role-description", roleSet);

            /*
             * Get the Role Object using AMStoreConnection
            */
            String orgDN = req.getParameter("orgName");
            Map roleMap = new HashMap();
            roleMap.put(roleName, attrValMap);
            AMOrganization  org = conn.getOrganization(orgDN);
            Set roles = org.createRoles(roleMap);
            Iterator iter = roles.iterator();
            contextRole = (AMRole)iter.next();
            return showCreateRoleSuccess();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
            return "Unable to create";
    }

    /**
     * This method describes the SDK usage for adding User to the Role.
     */

    public String addUsertoRole(HttpServletRequest request) {
        try {
            String userDN = request.getParameter("uid");
            Set userSet = new HashSet();
            userSet.add(userDN);
            contextRole.addUsers(userSet);
            return "Successfully added";
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return "Unable to add";
    }

    /* This method is for the GUI purposes */

    public String showCreateRole() {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>");
        sb.append("<HEAD>");
        sb.append("</HEAD>");
        sb.append("<BODY>");
        sb.append("<FORM name=\"createrole\" METHOD=POST ACTION=\"/amserver/sdksample\">");
        sb.append("<TABLE>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Create Role</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"rolename\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD><TD><B>Under Organization</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"orgName\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("</TR>");
        sb.append("<TR><TD></TD><TD></TD><TD></TD><TD>(Enter dn. For eg. o=iplanet.com,o=isp)</TD<</TR>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Description</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"roledescription\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("</TR>");
        sb.append("<TR>");
        sb.append("<TD><input type=SUBMIT NAME=\"createrole\" VALUE=\"Create Role\">");
        sb.append("</TD></TR>");
        sb.append("</TABLE>");
        sb.append("</FORM>");
        sb.append("</BODY>");
        sb.append("</HTML>");
        return sb.toString();
    }

    /* This method is for the GUI purposes */

    private String showCreateRoleSuccess() {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>");
        sb.append("<HEAD>");
        sb.append("</HEAD>");
        sb.append("<BODY>");
        sb.append("Created Role Successfully");
        sb.append("<FORM name=\"rolesuccessful\" METHOD=POST ACTION=\"/amserver/sdksample\">");
        sb.append("<TABLE>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Enter uid</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"uid\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("<TD><input type=SUBMIT NAME=\"addusertorole\" VALUE=\"Add User\">");
        sb.append("</TD></TR>");
        sb.append("<TR><TD ALIGN=LEFT VALIGN=MIDDLE><B>Enter the Organization Name</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"organization\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("</TR>");
        sb.append("</TABLE>");
        sb.append("</FORM>");
        sb.append("</BODY>");
        sb.append("</HTML>");
        return sb.toString();
    }

    /**
     * This method is for GUI purpose
     */

    private String showUserAddedSuccess(String userDN, AMStoreConnection conn) {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>");
        sb.append("<HEAD>");
        sb.append("</HEAD>");
        sb.append("<BODY>");
        sb.append("User added successfully");
        sb.append("<FORM name=\"printAttributes\" METHOD=POST ACTION=\"/amserver/sdksample\">");
        sb.append("<TABLE>");
        sb.append("<TR></TR>");
        sb.append("<TR><TD>The Attributes are: " + printAttributes(userDN, conn));
        sb.append("</TD></TR>");
        sb.append("</TABLE>");
        sb.append("</FORM>");
        sb.append("</BODY>");
        sb.append("</HTML>");
        return sb.toString();
    }

    /**
     * This method is used for to print the attributes.
     */

    public String printAttributes( String userDN, AMStoreConnection conn) {
        try {
            AMUser user = conn.getUser(userDN);
            String userAttr = user.getAttributes().toString();
            return userAttr;
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return "Unable to print";
    }
}
