/**
 * $Id: SampleOrgOperations.java,v 1.8 2005/06/24 16:54:02 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


package com.iplanet.am.samples.sdk;

import java.io.*;
import java.net.*;
import java.util.*;
import com.iplanet.sso.*;
import com.iplanet.am.sdk.*;
import com.sun.identity.authentication.internal.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class SampleOrgOperations {

    public static AMStoreConnection amsc = null;
    public static SampleOrgOperations soo;

    public static void main(String args[]) {
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(new AuthPrincipal("uid=amadmin,ou=People,o=iplanet.com,o=isp"), "netscape");
            soo = getSampleOrgOperations(token);
	    amsc = new AMStoreConnection(token);
            System.out.println(soo.createOrg(amsc));
            System.out.println(soo.getRegisteredServices(amsc));
            System.out.println(soo.registerService(amsc)); 
        } catch (Exception e) {
            System.out.println("Exception Message: " + e.getMessage());
            e.printStackTrace();
        }
    }

    SSOToken token = null;
    private static Map scoObjMap = new HashMap();

    /**
     * this org will be used for further sample operations on the 
     * same object
     */	
    private static AMOrganization contextOrg;

    /* Basic Constructor */

    public SampleOrgOperations(SSOToken token) {
        this.token = token;
        scoObjMap.put(token, this);
    }

    /* Use the same  object for multiple operations */

    public static SampleOrgOperations getSampleOrgOperations(SSOToken token) {
        SampleOrgOperations scoObj = (SampleOrgOperations)scoObjMap.get(token);
        if (scoObj == null ) {
            scoObj = new SampleOrgOperations(token);
        }
        return scoObj;
    }

  /**
   * This method will describe the SDK usage for creating a suborg
   * It uses AMStoreConnection to get the organization object and
   * creates sub org under it. This method is used for command line
   * It throws an AMException  if it's unble to create it and we throw
   * message "unable to create" to the GUI by catching the same
   */

    public String createOrg(AMStoreConnection conn) {
        try {
            /**
             * Define the organization 
             */
            String orgName = "sub_iplanet.com";
            Set orgs = new HashSet();
            orgs.add(orgName);
            /**
             * Define the DN of the organization according to DIT
             */
            String orgDN = "o=iplanet.com,o=isp";
            /**
             * Get the org object -SDK Usage
             */
            contextOrg = conn.getOrganization(orgDN);
            /**
             * Create sub organization -SDK Usage
             */
            contextOrg.createSubOrganizations(orgs);

            return "Successfully Created the organization";
        } catch (Exception ex) {
            ex.printStackTrace();
        }
          return "Unable to create";
    }

    /**
     * This method describes the SDK usage for getting the registered services.
     * It uses AMStoreConnection to get the organization object and
     * returns the String of registered services.
     * This method is used for command line.
     */

    public String getRegisteredServices(AMStoreConnection conn) {
        try {
            /**
             * Define the DN of the organization according to DIT
             */ 
            String orgDN = "o=iplanet.com,o=isp";
            Set servicesSet = new HashSet();
            AMOrganization org = conn.getOrganization(orgDN);
            /**
             * Get Registered Services - SDK Usage
             */
            servicesSet = org.getRegisteredServiceNames();
            return "The Registered services: " + servicesSet.toString();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
            return "Unable to get Registered Services";
    }

    /**
     * This method describes the SDK usage for registering the services.
     * It uses AMStoreConnection to get the organization object.
     */

    public String registerService(AMStoreConnection conn) { 
        try {
            /**
             * Define the DN of the organization according to DIT
             */
            String orgDN = "o=iplanet.com, o=isp";
            String serviceName = "iPlanetAMAuthRadiusService";
            AMOrganization org = conn.getOrganization(orgDN);
            /**
             * Register the service - SDK Usage
             */
            org.registerService(serviceName, false, false);
            return "Successfully registered";
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return "Unable to register";
    }


    /* This method is for the GUI purposes */

    public String showCreateOrg() {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>");
        sb.append("<HEAD>");
        sb.append("</HEAD>");
        sb.append("<BODY>");
        sb.append("<FORM name=\"createorg\" METHOD=POST ACTION=\"/amserver/sdksample\">");
        sb.append("<TABLE>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Create Organization</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"organization\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("<TD><B>Under Organization</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"orgName\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("</TR>");
        sb.append("<TR><TD></TD><TD></TD><TD></TD><TD>(Enter dn. For eg. o=iplanet.com,o=isp)</TD></TR>");
        sb.append("<TR>");
        sb.append("<TD><input type=SUBMIT NAME=\"createorg\" VALUE=\"Create Organization\">");
        sb.append("</TD></TR>");
        sb.append("</TABLE>");
        sb.append("</FORM>");
        sb.append("</BODY>");
        sb.append("</HTML>");
        return sb.toString();
    }

    /* This method is for the GUI purposes */

    private String showCreateOrgSuccess() {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>");
        sb.append("<HEAD>");
        sb.append("</HEAD>");
        sb.append("<BODY>");
        sb.append("Created Organization Successfully");
        sb.append("<FORM name=\"orgsuccessful\" METHOD=POST ACTION=\"/amserver/sdksample\">");
        sb.append("<TABLE>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Enter Organization Name</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"orgname\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("<TD><input type=SUBMIT NAME=\"getregisteredservice\" VALUE=\"Get Registered Services\">");
        sb.append("</TD></TR>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Enter the Organization Name for Service</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"serviceorgname\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("</TR>");
        sb.append("<TR>");
        sb.append("<TD ALIGN=LEFT VALIGN=MIDDLE><B>Enter the Service Name</B></TD>");
        sb.append("<TD VALIGN=MIDDLE><INPUT TYPE=\"text\" NAME=\"servicename\" VALUE=\"\" SIZE=32 MAXLENGTH=64></TD>");
        sb.append("<TD><input type=SUBMIT NAME=\"addservice\" VALUE=\"Add Service\">");
        sb.append("</TD></TR>");
        sb.append("</TABLE>");
        sb.append("</FORM>");
        sb.append("</BODY>");
        sb.append("</HTML>");
        return sb.toString();
    }

    private void storeOrgAttributes(String attribute, String value, Map orgMap) {
        Set orgSet = new HashSet();
        orgSet.add(value);
        orgMap.put(attribute, orgSet);
    }

  /**
   * This method will describe the SDK usage for creating a suborg
   * It uses AMStoreConnection to get the organization object and
   * creates sub org under it. 
   * It throws an AMException  if it's unble to create it and we throw
   * message "unable to create" to the GUI by catching the same
   */

    public String createOrg(HttpServletRequest req, AMStoreConnection conn) {
        try {
	    String orgName = req.getParameter("organization");
	    Set orgs = new HashSet();
	    orgs.add(orgName);
            String orgDN = req.getParameter("orgName");
            /**
             * Get the org object -SDK Usage
             */
            contextOrg = conn.getOrganization(orgDN);
            /**
             * Create sub organization -SDK Usage
             */
	    contextOrg.createSubOrganizations(orgs);

            return showCreateOrgSuccess();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
          return "Unable to create";
    }

    /**
     * This method describes the SDK usage for getting the registered services.
     * It uses AMStoreConnection to get the organization object and
     * returns the String of registered services.
     */

    public String getRegisteredServices(HttpServletRequest request, AMStoreConnection conn) {
        try {
            String orgDN = request.getParameter("orgname");
            Set servicesSet = new HashSet();
            AMOrganization org = conn.getOrganization(orgDN);
            /**
             * Get Registered Services - SDK Usage
             */
	    servicesSet = org.getRegisteredServiceNames();
            return servicesSet.toString();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
            return "Unable to get Registered Services";
    }  

    /**
     * This method describes the SDK usage for registering the services. 
     * It uses AMStoreConnection to get the organization object. 
     */

    public String registerService(HttpServletRequest request, AMStoreConnection conn) {
        try {
            String orgDN = request.getParameter("serviceorgname");
            String serviceName = request.getParameter("servicename");
            AMOrganization org = conn.getOrganization(orgDN);
            /**
             * Register the service - SDK Usage
             */
            org.registerService(serviceName, false, false);
            return "Successfully registered";
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return "Unable to register";
    }

}
