/**
 * $Id: SSOTokenFromRemoteServlet.java,v 1.4 2005/06/24 16:54:05 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


import java.net.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.iplanet.sso.*;

/**
 * This sample describes using ssotoken from a remote webserver. Decoded DSAME
 * cookie will be used to create the SSOToken.
 * Before using this sample, please generate the sidstring and replace with
 * the one that is hardcoded.
 * Please see remote.html for further details
 *
 */

public class SSOTokenFromRemoteServlet extends HttpServlet {

    public void init() throws ServletException {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response){
     
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();

            /** 
	     * Create the SSO Token from the sid string 
               (Note: If u are taking this from Session debug file, we do not 
		need to decode it, but if it's from the cookie, we do need to 
		decode it.) 
	     * This string needs to be replaced with the one that is generated
	     * by doing login into your DSAME
	     */

	    String sidstr = "AQAA/K9JqiJGpdjW0CsFclOhEVNBaOLo4vUMBidIQjf0sBDt7rk4OfOUZ8KcSpRjAk15CcYlNtRPt476aQKEhUjCV3r9n7GTJMUz7I8lLemO7V4=@shivalik.red.iplanet.com-2%3A3c3a3c1a%3Aa8117551d380c129";

            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(sidstr);

            /* use isValid to method to check if the token is valid or not
             * this method retuns true for valid token, false otherise
             */
            if (manager.isValidToken(token)) {
                /* let us get all the values from the token */

                String host = token.getHostName();
                java.security.Principal principal = token.getPrincipal();
                String authType = token.getAuthType();
                int level = token.getAuthLevel();
                InetAddress ipAddress = token.getIPAddress();
                long maxTime = token.getMaxSessionTime();
                long idleTime = token.getIdleTime();
                long maxIdleTime = token.getMaxIdleTime();
                long timeLeft = token.getTimeLeft();
                out.println("SSOToken host name: " + host);
                out.println("SSOToken Principal name: " + principal.getName());
                out.println("Authentication type used: " + authType);
                out.println("IPAddress of the host: " + 
                          ipAddress.getHostAddress());
            }  
            /* let us try to validate the token again, with another method 
             * if token is invalid, this method throws excpetion
             */
            manager.validateToken(token);

            /* let us get the SSOTokenID associated with the token */
            SSOTokenID tokenId = token.getTokenID();
   
            String id = tokenId.toString();

            /* print the string representation of the token */

            out.println("The token id is " + id);

            /* let us set some properties in the token. We can get the values
             * of set properties later
             */
            token.setProperty("Company", "Sun Microsystems");
            token.setProperty("Country", "USA");
            String name = token.getProperty("Company");
            String country = token.getProperty("Country");

            out.println("Property: Company is - " + name); 
            out.println("Property: Country is - " + country); 

            out.println("SSO Token Validation test Succeeded");
            /* let us add a listener to the SSOToken. Whenever a token
             * event arrives, ssoTokenChanged method of the listener will
             * get called.
             */
                 out.flush();
        } catch (com.iplanet.sso.SSOException e) {
            try {
                out.println("SSO Exception Invalid Session: " + e.getMessage());
                e.printStackTrace();
                out.flush();
            }catch (Exception ee) {
            }
        } catch (Exception e) {
            try {
                out.println("rException Message: " + e.getMessage());
                out.println("Exception Message: " + e);
                e.printStackTrace();
                out.flush();
            }catch (Exception ee) {
            }
        }
    }    

}
