/**
 * $Id: VerifySignature.java,v 1.7 2005/06/24 16:54:00 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */

import java.io.*;
import java.util.*;
import java.security.KeyStore;
import java.security.cert.*;
import java.security.PrivateKey;
import java.security.PublicKey; 
import java.security.cert.X509Certificate;
import org.w3c.dom.*;
import org.xml.sax.SAXException;
import org.xml.sax.InputSource;
import javax.xml.parsers.*;
import javax.xml.transform.TransformerException;
import com.sun.org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import com.sun.org.apache.xml.security.c14n.*;
import com.sun.org.apache.xml.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.security.signature.*;
import com.sun.org.apache.xml.security.keys.*;
import com.sun.org.apache.xml.security.keys.content.*;
import com.sun.org.apache.xml.security.keys.content.x509.*;
import com.sun.org.apache.xml.security.keys.keyresolver.*;
import com.sun.org.apache.xml.security.keys.storage.*;
import com.sun.org.apache.xml.security.keys.storage.implementations.*;
import com.sun.org.apache.xml.security.utils.*;
import com.sun.org.apache.xml.security.transforms.*;
import com.sun.org.apache.xml.security.Init;
import com.sun.identity.saml.common.*;
import com.sun.identity.saml.xmlsig.*;
import com.sun.identity.saml.assertion.*; 

public class VerifySignature {
    /**
     * @param args the command line arguments
     */
    public static void main (String args[]) {
        String signatureFile = "signature.xml";
        if (args.length == 1) {
            signatureFile = args[0];
        }
        
        try {
            JKSKeyProvider keys=new JKSKeyProvider();
            AMSignatureProvider asp = new AMSignatureProvider();
            XMLSignatureManager sm = XMLSignatureManager.getInstance(keys, asp);
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setNamespaceAware(true);
            DocumentBuilder _documentBuilder = fac.newDocumentBuilder(); 
            InputSource is = new InputSource(new FileReader(signatureFile));
            Document doc = _documentBuilder.parse(is);
            Element element = doc.getDocumentElement();
            if (element == null) {
                System.out.println("Input signature file is null");
                return; 
            }
            
            System.out.println("=====verify signature in file " + signatureFile 
                               + "=====");
            boolean val = sm.verifyXMLSignature(element); 
            if (val) {
                System.out.println("Doc is valid"); 
            } else {
                System.out.println("Doc is invalid."); 
            }
        } catch (Exception e) {
            System.out.println("VerifySignature Error: " + e.getMessage());
            e.printStackTrace(); 
            System.exit(0);
        }
        System.exit(0);
    }
}
