<%--
    Copyright (c) 2005 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>



<%@ page import="java.util.*" %>
<%@ page import="java.net.*" %>
<%@ page import="java.io.*"%>
<%@ page import="com.sun.identity.saml.common.*"%>
<%@ page import="org.w3c.dom.Document"%>
<%@ page import="org.w3c.dom.Element"%>

<%@ page import="com.sun.identity.saml.assertion.*"%>
<%@ page import="com.iplanet.am.samples.saml.sso.*"%>
<%@ page import="com.iplanet.sso.*"%>
<%@ page import="com.iplanet.am.util.*"%>
<%@ page import="java.net.*"%>

<html>
<head>
<title>Sample Application doing SSO</title>
</head>
<body>

    <% 
    String name = null;
    String authority = null;
    String email = null;
    String membershipLevel = null;
    String uri = 
	SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
    StringBuffer urlSB=new StringBuffer();
    Utils.debug.message("scheme:"+request.getScheme());
    urlSB.append(request.getScheme()).append("://").
          append(request.getServerName());
    urlSB.append( ":" ).append( request.getServerPort() );
    String reqBase=urlSB.toString();

    Utils.debug.message("getting assertions from posted data");
    List assList = new ArrayList();
   
    Enumeration enum1 = request.getParameterNames();
    for (int i =0; enum1.hasMoreElements(); i++) {
	String paramName = ((String)enum1.nextElement()).toUpperCase();
	if (paramName.equals("ASSERTION")) {
	    String arr[] = request.getParameterValues("ASSERTION");
	    Utils.debug.message("app_postprofile.jsp:got "+arr.length+" assertions.");
            for (int j =0; j< arr.length; j++) {
		String arrString = URLDecoder.decode(arr[j]);
		Utils.debug.message("app_postprofile.jsp:arr["+j+"]:"+arrString);
 	        Document doc = Utils.toDOMDocument(arrString);
        	Element el = doc.getDocumentElement();
		if (el == null) {
		   Utils.debug.message("could not parse Element");
		} else { 
	            assList.add(new Assertion(el));
		}
	    }
	    break;
	}
    }
    if (assList == null || assList.size() == 0) {
	Utils.debug.error("Could not find Assertion in POST");
    %>
 	<p>Could not find Assertion in POST.
    <%
	return;
    }
    Assertion assertion = (Assertion)assList.get(0);
    Utils.debug.message("app_postprofile.jsp: assertion="+assertion.toString());
    authority = assertion.getIssuer();
    Utils.debug.message("app_postprofile.jsp:authority="+authority);
    // here just taking in the first assertion to find the subject, and
    // also assuming that all assertions are for the same Subject.
    // This app should know that its getting attribute statements too.
    // Also assuming that all the attribute statements are in the 1st
    // Assertion, which is the case with Access Manager 6.0 which sends one assertion with
    // SSO Ststement and the Attribute statements as configured by the 
    // siteAttributeMapper plug in.

    boolean attFound = false;
    Set statements= assertion.getStatement();
    Iterator iterator = statements.iterator();
    while (iterator.hasNext()) {
    	com.sun.identity.saml.assertion.Statement statement = 
	    (com.sun.identity.saml.assertion.Statement) iterator.next();
        Subject subject = ((SubjectStatement)statement).getSubject();
        NameIdentifier nid = subject.getNameIdentifier();
        if (nid != null) {
            name = nid.getName();
	}
        Utils.debug.message("app_postprofile.jsp:name="+name);
	if (!attFound && 
	    (statement.getStatementType() == 
		com.sun.identity.saml.assertion.Statement.ATTRIBUTE_STATEMENT)) 
	{
	    Iterator attributes = ((AttributeStatement)statement).
		getAttribute().iterator();
	    while (attributes.hasNext()) {
		Attribute att = (Attribute)attributes.next();
		if (att.getAttributeName().equals("membershipLevel")) {
        	    Utils.debug.message("found membershipLevel attribute");
		    // assuming that list has only one value
	 	    membershipLevel =   Utils.getElementValue((Element)
			att.getAttributeValue().get(0));
    		    Utils.debug.message("app_postprofile.jsp:membershipLevel="
			+membershipLevel );
		}
		if (att.getAttributeName().equals("email")) {
        	    Utils.debug.message("found email attribute");
		    // assuming that list has only one value
	 	    email =   Utils.getElementValue((Element)att.
			getAttributeValue().get(0));
    		    Utils.debug.message("app_postprofile.jsp:email="+email );
		}
		if ((membershipLevel != null) && (email != null)) {
		    attFound = true;
		    break; //both found no need to see more attribute sts.
		}
	    }
	}
	if ((nid != null) && attFound) {
	    break;
	}
    }
    SSOTokenManager tm = SSOTokenManager.getInstance();
    String user = "";
    SSOToken token = null;
    try {
        token = tm.createSSOToken(request);
	user = name;
    } catch (Exception e) {
	Utils.debug.error("app_postprofile.jsp: error during token creation: "
	    +e.getMessage());
    %>
    <% } %>
	<% if ((token == null) || (user == null) || (user.equals("")))  { %>
	<% 
	String forward = reqBase+uri+"/UI/Login"
	    + "?goto="+URLEncoder.encode(reqBase+uri
	    +"/SAMLPOSTProfileServlet?TARGET="+reqBase+"/demo/app_postprofile.jsp");
	Utils.debug.message("forward string is:"+forward);
	response.sendRedirect(forward); %>
    <% } else { %>
        <%String tokenStr = token.getTokenID().toString();
        if ((tokenStr == null)|| (tokenStr.equals(""))) { 
        %>
	    <p> token is null
        <%} %>
	
        <%if ((membershipLevel == null)|| (membershipLevel.equals(""))) { %>
	    <p> membershipLevel is null
        <%  } else { %>
	    <p> membershipLevel is :<b><%= membershipLevel%></b>
	    <%
  	    token.setProperty("name",name);
	    token.setProperty("email",email);
	    token.setProperty("authority",authority);
	    token.setProperty("membershipLevel",membershipLevel);
	    %>
    	    <%  if (membershipLevel.equalsIgnoreCase("gold")) { %>
	        <jsp:forward page="gold.jsp"/>
    	    <%  } else if (membershipLevel.equalsIgnoreCase("silver")) { %>
	        <jsp:forward page="silver.jsp"/>
    	    <%  } else if (membershipLevel.equalsIgnoreCase("bronze")) { %>
	        <jsp:forward page="bronze.jsp"/>
    	    <%  } %>	
        <% } %>
    <% } %>
</body>    
</html>    
