/**
 * $Id: TestSiteAttributeMapper.java,v 1.6 2005/06/24 16:53:58 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


package com.iplanet.am.samples.saml.sso;

import java.util.List;
import java.util.ArrayList;
import com.iplanet.sso.*;
import com.sun.identity.saml.assertion.*;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.plugins.*;
import com.iplanet.am.samples.saml.sso.Utils;
import com.iplanet.am.sdk.*;
import org.w3c.dom.Document;



/**
 * This is an implementation of <code>SiteAttributeMapper</code> interface
 * to return a List of <code>Attribute</code> objects which are returned
 * as <code>AttributeStatements</code> elements, as part of the
 * Authentication Assertion returned to the partner during the
 * SSO scenario of Browser Atrifact and POST profile
 */

public class TestSiteAttributeMapper implements SiteAttributeMapper {

    /**
     * Returns <code>List</code> of <code>Attribute</code> objects.
     *
     * @param token Single-Sign-On token of the user performing the
     *        Single-Sign-On operation.
     * @return <code>List</code> of <code>Attribute</code> objects.
     *         <code>Attribute</code> is defined in the SAML SDK as part of
     *         <code>com.sun.identity.saml.assertion</code> package.
     */
    public List getAttributes(SSOToken token) throws SAMLException {
	if (token == null) {
	    if (Utils.debug.messageEnabled()) {
	        Utils.debug.message("TestSiteAttributeMapper:token passed "
		    + "is null");
	    }
	}
	String name = null;
        AMUser user = null;
	String emailAddress = null;
	String membershipLevel = null;
	try {
	    name = token.getPrincipal().getName();
            AMStoreConnection dpc = new AMStoreConnection(token);
	    user = dpc.getUser(name);
	    emailAddress = user.getStringAttribute("mail");
	    // using user attribute postaladdress to store membershipLevel
	    // information for the sake of this sample.
	    membershipLevel = 
		user.getStringAttribute("postaladdress");
	    if (Utils.debug.messageEnabled()) {
	        Utils.debug.message("emailAddress is :"+emailAddress);
	        Utils.debug.message("membershipLevel is :"+membershipLevel);
	    }
	} catch (AMException  ame) {
	    if (Utils.debug.messageEnabled()) {
	        Utils.debug.message("TestSiteAttributeMapper:AMException",
		    ame);
	    }
	    throw new SAMLException(ame.getMessage());
	} catch (SSOException  ssoe) {
	    if (Utils.debug.messageEnabled()) {
	        Utils.debug.message("TestSiteAttributeMapper:SSOException",
		    ssoe);
	    }
	    throw new SAMLException(ssoe.getMessage());
	}
	List atts = new ArrayList();

	List vals = new ArrayList();
	String attval = "<saml:AttributeValue xmlns:saml=\"urn:oasis:names:tc:"
	    + "SAML:1.0:assertion\""+">" + emailAddress 
	    +"</saml:AttributeValue>";
	Document domNode = Utils.toDOMDocument(attval);
	vals.add(domNode.getDocumentElement());
	Attribute att = new Attribute("email",
	    "TestSiteAttributeMapper attributes", vals);
	if (Utils.debug.messageEnabled()) { 
	    Utils.debug.message("att:"+att.toString());
	}
	atts.add(att);

	vals = new ArrayList();
	attval = "<saml:AttributeValue xmlns:saml=\"urn:oasis:names:tc:"
	    + "SAML:1.0:assertion\""+">"
	    + membershipLevel + "</saml:AttributeValue>";
	domNode = Utils.toDOMDocument(attval);
	vals.add(domNode.getDocumentElement());
	if (Utils.debug.messageEnabled()) { 
	    Utils.debug.message("vals is:"+vals.toString());
	}
	att = new Attribute("membershipLevel",
	    "TestSiteAttributeMapper attributes", vals);
	if (Utils.debug.messageEnabled()) { 
	    Utils.debug.message("att:"+att.toString());
	}
	atts.add(att);
	return atts;
    }
}
