/**
 * $Id: PolicyEvaluation.java,v 1.9 2005/06/24 16:53:50 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


import java.io.*;
import java.util.*;

import com.iplanet.sso.*;
import com.sun.identity.policy.*;

/**
  Sample class for testing Policy Evaluation API
 */


public class PolicyEvaluation extends BaseUtils {

    static final int EXIT_STATUS_NOERROR = 0;
    static final int EXIT_STATUS_ERROR = 1;
    
    static final String REQUEST_AUTH_LEVEL = "requestAuthLevel";
    static final String REQUEST_AUTH_SCHEMES = "requestAuthSchemes";
    static final String REQUEST_IP = "requestIp";
    static final String REQUEST_DNS_NAME = "requestDnsName";
    static final String REQUEST_TIME = "requestTime";
    static final String REQUEST_TIME_ZONE = "requestTimeZone";

    static SSOToken ssoToken = null;

    public static void main(String[] args)
    {

        loadProperties();

        try {
            String serviceName = getProperty("pe.servicename");
            String resourceName = getProperty("pe.resourcename");
            Set actionNames = getPropertyValues("pe.actionnames");

            PolicyEvaluator pe = new PolicyEvaluator(serviceName);

            Map envParams = new HashMap();

            String authLevel = getProperty("pe.authlevel");
            if ((authLevel != null) && (!authLevel.equals(""))) {
                try {
                    envParams.put(REQUEST_AUTH_LEVEL, new Integer(authLevel));
                } catch (NumberFormatException e) {
                    System.out.println(
                                "WARNING: The pe.authlevel is invalid. ");
                }
            }
      
            String ip = getProperty("pe.requestip");
            if ((ip != null) && (!ip.equals(""))) {
                envParams.put(REQUEST_IP, ip);
            }

            Set dnsNames = getPropertyValues("pe.dnsname");
            if ((dnsNames != null) && (!dnsNames.isEmpty())) {
                envParams.put(REQUEST_DNS_NAME, dnsNames);
            }

            Set schemes = getPropertyValues("pe.authschemes");
            if ((schemes != null) && (!schemes.isEmpty())) {
                envParams.put(REQUEST_AUTH_SCHEMES, schemes);
            }

            TimeZone tz = TimeZone.getDefault();
            envParams.put(REQUEST_TIME_ZONE, tz);

            String time = getProperty("pe.time");
            if ((time != null) && (!time.equals(""))) {
                try {
                    envParams.put(REQUEST_TIME, new Long(time));
                } catch (NumberFormatException e) {
                    if (!time.equalsIgnoreCase("currenttime")) {
                        System.out.println("WARNING: The pe.time value is "
                          + "invalid. The current time is used instead.");
                    }
                    envParams.put(REQUEST_TIME, 
                                  new Long(System.currentTimeMillis()));
                }
            }

            SSOToken token = getToken();
            if (token == null) {
                System.exit(EXIT_STATUS_ERROR);
            }
            
            PolicyDecision policyDecision = pe.getPolicyDecision(
                  token, resourceName, actionNames, envParams);

            System.out.println("\n-------------------------");
            System.out.println("Policy Evaluation Results");
            System.out.println("-------------------------");
            System.out.println(policyDecision.toXML());
        } catch (Exception e) {
            System.out.println("Exception : " + e.getMessage());
            e.printStackTrace();
            System.exit(EXIT_STATUS_ERROR);
        }

        System.exit(EXIT_STATUS_NOERROR);
    }

} 
