<%--
    Copyright (c) 2005 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>


<%@page import="java.io.*, java.util.*, com.sun.identity.saml.common.*, com.sun.identity.liberty.ws.disco.*, com.sun.identity.liberty.ws.disco.common.*,javax.xml.transform.stream.*,com.iplanet.sso.*,com.sun.liberty.LibertyManager, com.sun.identity.liberty.ws.security.*, com.iplanet.am.util.*" %>


<html xmlns="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
    <head><title>Discovery Service Query Sample</title></head>
    <body bgcolor="white">
        <h1>Discovery Service Query Sample</h1>
<%
        if (request.getMethod().equals("GET")) {
            String discoOfferingFile = 
                request.getParameter("discoveryResourceOffering");
            if (discoOfferingFile == null) {
                discoOfferingFile= "";
            } 
	
            String providerID = request.getParameter("providerID");
%>
            <form method="POST">
                <table>
                    <tr>
                        <td>ResourceOffering (for discovery service itself)</td>
                        <td>
                             <textarea rows="2" cols="50" name="discoResourceOffering"><%= discoOfferingFile %></textarea>
                         </td>
                    </tr>
                    <tr>
                        <td>ServiceType to look for</td>
                        <td><input type="text" name="serviceType" value="urn:liberty:id-sis-pp:2003-08"/></td>
                    </tr>
                </table>
                <input type="hidden" name="providerID" 
                    value='<%= providerID %>'>
                <input type="submit" value="Send Discovery Lookup Request" />
            </form>
<%
        } else {
            String resourceXMLfile = 
                   request.getParameter("discoResourceOffering");
	    String resourceXML = null;
            try {
                BufferedReader bir = new BufferedReader(
                      new FileReader(resourceXMLfile));
                StringBuffer buffer = new StringBuffer(2000);
                int b1;
                while ((b1=bir.read ())!= -1) {
                    buffer.append((char) b1);
                }
                resourceXML = buffer.toString();
            } catch (Exception e) {
                %>Warning: cannot read disco resource offering.<%
                  e.printStackTrace();
            }
	    
            String serviceType = request.getParameter("serviceType");
            String providerID = request.getParameter("providerID");
	    String fnSuffix = null; 
            if (resourceXML == null || resourceXML.equals("")) {
                %>ERROR: resource offering missing<%
            } else {
                ResourceOffering offering;
                try {
		    offering = new ResourceOffering(
				DiscoUtils.parseXML(resourceXML));
                    List list = LibertyManager.getDiscoveryBootStrapCredentials(                         request, providerID, "SP");
                    DiscoveryClient client = new DiscoveryClient(
				offering,
				SSOTokenManager.getInstance().createSSOToken(
                                request),
				providerID,
			        list);	
                    List types = new ArrayList();
                    if ((serviceType != null) && !(serviceType.equals(""))) {
                        types.add(serviceType);
                    }
		    QueryResponse result = client.getResourceOffering(types);
                    List results = result.getResourceOffering();
		    if ((results == null) || (results.size() == 0)) {
			%>
			<h2>Query result:</h2>
			 No ResourceOffering found.
			<p><a href="index.jsp">Return to index.jsp</a></p>
			<%
		    } else {
                        %>
			<h2>Query result :</h2>
			<pre><%= SAMLUtils.displayXML(result.toString()) %></pre>
			<%
                        List creds = result.getCredentials();
                    	int itemSize = results.size();
                    	for (int i = 0; i < itemSize; i ++) {
                    	    ResourceOffering offer =
				(ResourceOffering) results.get(i);
                            String remoteProvider = 
                                  offer.getServiceInstance().getProviderID();
                            fnSuffix = remoteProvider.replace('/','_');
			    String entryID = offer.getEntryID();
			    String resOffFN = "/tmp/RO_"+ fnSuffix + "_" + i;
                            String secAssertion = null;
                            try {
	                        FileWriter resOffWriter = 
                                      new FileWriter(resOffFN);
	                        resOffWriter.write(offer.toString());
	                        resOffWriter.close();
                            } catch(Exception ex) {
	                        %>Cannot write security assertion to file:<%
                                 ex.printStackTrace();
                            }

			if(creds != null && creds.size() != 0) {
                           SecurityAssertion secAss =
                               (SecurityAssertion)creds.get(0);
                           secAssertion = "/tmp/secAFN_" + fnSuffix; 
                           try {
                               FileWriter secWriter =
                                     new FileWriter(secAssertion);
                               secWriter.write(secAss.toString(true, true));
                               secWriter.close();
                           } catch(Exception ex) {
                               %>Cannot write security assertion to file:<%
                               ex.printStackTrace();
                           }
                        }

                        %>
<pre><%= SAMLUtils.displayXML(offer.toString()) %></pre>
<form method="GET" action="id-sis-pp-query.jsp">
<input type='hidden' name='providerID' value='<%= providerID %>'>
<input type='hidden' name='resOffFN' value='<%=resOffFN %>'>
<input type='hidden' name='secAssertion' value='<%=secAssertion %>'>
<input type="submit" name="Submit" value="Send PP Query" />
</form>

<p>

<form method="GET" action="id-sis-pp-modify.jsp">
<input type='hidden' name='providerID' value='<%= providerID %>'>
<input type='hidden' name='resOffFN' value='<%=resOffFN %>'>
<input type='hidden' name='secAssertion' value='<%=secAssertion %>'>
<input type="submit" name="Submit" value="Send PP Modify" />
</form>

<p>

<form method="GET" action="discovery-modify.jsp">
<input type='hidden' name='providerID' value='<%= providerID %>'>
<input type='hidden' name='discoveryResourceOffering'
    value='<%= resourceXMLfile %>'>
<input type='hidden' name='entryID' value='<%= entryID %>'>
<input type="submit" name="Submit" value="Remove this PP Resource Offering from Discovery Service" />
</form>

<hr>
                            <%
			}
                    }
                } catch (Throwable t) {
                    t.printStackTrace();
                    StringWriter buf = new StringWriter();
                    t.printStackTrace(new PrintWriter(buf));
                    %>
                        ERROR: caught exception:
                        <pre><%= SAMLUtils.displayXML(buf.toString()) %></pre>
                    <%
                }
            }
        } 


%>
        <hr />
    </body>
</html>
