<%--
    Copyright (c) 2005 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>



<%@page 
import="java.io.*, 
java.util.*,
java.security.Principal,
com.iplanet.sso.SSOToken,
com.iplanet.sso.SSOTokenManager,
com.iplanet.sso.SSOException,
com.iplanet.am.util.XMLUtils,
com.sun.identity.saml.common.*,
com.sun.identity.liberty.ws.disco.*,
com.sun.identity.liberty.ws.disco.jaxb.*,
com.sun.identity.liberty.ws.disco.plugins.Default64ResourceIDMapper,
com.sun.liberty.LibertyManager,
org.w3c.dom.*,
javax.xml.bind.*,
javax.xml.transform.stream.*"
%>

<html xmlns="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
    <head><title>Discovery Service Boot Strapping</title></head>
    <body bgcolor="white">
	<h1>Discovery Service Boot Strapping Resource Offering</h1>
<%
    try {
        // SP provider ID
        String providerID = "http://www.sp1.com";
        // discovery service provider id
        String dsProviderID = 
        "http://www.idp1.com:IDP_SERVER_PORT/SERVICE_DEPLOY_URI/Liberty/disco"; 
        SSOTokenManager manager = SSOTokenManager.getInstance();
        SSOToken ssoToken = manager.createSSOToken(request);
        if(ssoToken != null && manager.isValidToken(ssoToken)) {
            NodeList offerings = LibertyManager.
                getDiscoveryBootStrapResourceOfferings(request, providerID);
            if(offerings == null) {
                %>ERROR: no resource offering in AttributeStatement.<%
            } else {
                JAXBContext jc = JAXBContext.newInstance(
                        "com.sun.identity.liberty.ws.disco.jaxb");
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                Marshaller marshaller = jc.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output",
                                Boolean.TRUE);
                StreamSource src = new StreamSource(new StringReader(
                                XMLUtils.print(offerings.item(0))));
                Object o = unmarshaller.unmarshal(src);
                if (!(o instanceof ResourceOfferingType)) {
                    %>invalid resource offering<%
                } else {
                    ByteArrayOutputStream buf1 = new ByteArrayOutputStream();
                    marshaller.marshal((ResourceOfferingElement) o, buf1);
                    // get reourceID
                    ResourceIDType resourceIDType = 
                        ((ResourceOfferingType) o).getResourceID();
                    String userDN = (new Default64ResourceIDMapper()).
                            getUserID(dsProviderID, resourceIDType.getValue());
                    %>
<pre><%= SAMLUtils.displayXML(buf1.toString()) %></pre>

<form method="GET" action="discovery-query.jsp">
<input type='hidden' name='providerID' value='<%= providerID %>'>
<input type='hidden' name='discoveryResourceOffering' 
    value='<%= buf1.toString() %>'>
<input type="submit" name="Submit" value="Send Discovery Lookup" />
</form>
<p>
<form method="GET" action="discovery-modify.jsp">
<input type='hidden' name='providerID' value='<%= providerID %>'>
<input type='hidden' name='userDN' value='<%= userDN %>'>
<input type='hidden' name='discoveryResourceOffering' 
    value='<%= buf1.toString() %>'>
<input type="submit" name="Submit" value="Add EP Resource Offering" />
</form>
		   <%
                } 
	    }
        } else {
	    %>ERROR: user not logged in.<%
        }
    } catch (Exception ex) {
        StringWriter bufex = new StringWriter();
        ex.printStackTrace(new PrintWriter(bufex));
        %>
            ERROR: caught Exception:
            <pre>
        <%
            out.println(bufex.toString());
        %>
            </pre>
        <%
    }
%>
	<hr/>
    </body>
</html>
