/**
 * $Id: LogSample.java,v 1.4 2005/06/24 16:53:37 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


import java.io.*;
import java.util.*;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

import com.iplanet.sso.SSOTokenManager;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.log.Logger;
import com.sun.identity.log.LogRecord;

public class LogSample {

    private static String USAGE =
	"Usage: LogSample [ -o <orgname> -u <username> -p <userpassword> ] " +
	"-n <logName> -m <message> -l <loggedByUser> -w <loggedByUserPassword";

    static final int INVALID = 0;
    static final int USER_SID = 1;
    static final int LOG_NAME = 2;
    static final int MESSAGE = 3;
    static final int LOGGED_BY_SID = 4;
    static final int USER_PWD = 5;
    static final int LOGGED_BY_PWD = 6;
    static final int ORG_NAME = 7;
    static Map OPTIONS = new HashMap();

    static {
        OPTIONS.put("-u", new Integer(USER_SID));
        OPTIONS.put("-n", new Integer(LOG_NAME));
        OPTIONS.put("-m", new Integer(MESSAGE));
        OPTIONS.put("-l", new Integer(LOGGED_BY_SID));
        OPTIONS.put("-p", new Integer(USER_PWD));
        OPTIONS.put("-w", new Integer(LOGGED_BY_PWD));
        OPTIONS.put("-o", new Integer(ORG_NAME));
    }

    private static int getToken(String arg) {
        try {
            return(((Integer)OPTIONS.get(arg)).intValue());
        } catch (Exception e) {
            return 0;
        }
    }
    private static void showUsage() {
        System.err.println(USAGE);
        System.exit(1);
    }

    public static void main(String[] args) {
        
	if (args.length == 0) {
            showUsage();
        }

        int userSID = 0;
	int userPWD = 0;
        int logName = 0;
        int message = 0;
        int loggedBySID = 0;
        int loggedByPWD = 0;
	int orgName = 0;
	String orgname = "/";
        int i = 0;
        while (i < args.length) {
            int opt = getToken(args[i]);

            switch(opt) {
                case ORG_NAME:
                    i++;
                    orgname = args[i];
                    break;
                case USER_SID:
                    i++;
                    userSID = i;
                    break;
                case USER_PWD:
                    i++;
                    userPWD = i;
                    break;
                case LOG_NAME:
                    i++;
                    logName = i;
                    break;
                case MESSAGE:
                    i++;
                    message = i;
                    break;
                case LOGGED_BY_SID:
                    i++;
                    loggedBySID = i;
                    break;
                case LOGGED_BY_PWD:
                    i++;
                    loggedByPWD = i;
                    break;
                default:
                    showUsage();
            }
            i++;
        }
        
        if (logName == 0 ) {
            System.err.println("LogSample: logName is null");
            showUsage();
        }
        if (loggedBySID == 0 || loggedByPWD == 0 ) {
            System.err.println("LogSample: logged by username or password is null");
            showUsage();
        }

        try {
	    SSOToken loggedByToken = getSessionToken(orgname,
		args[loggedBySID], args[loggedByPWD]);

	    SSOToken userToken = null;
	    if (userSID != 0) {
		userToken =getSessionToken(orgname,
		    args[userSID], args[userPWD]);
	    }

            LogRecord logRecord = null;
            if (userSID == 0) {
                logRecord = new LogRecord(java.util.logging.Level.INFO, args[message]);
            } else {
                logRecord = new LogRecord(java.util.logging.Level.INFO, args[message], userToken);
            }

            logRecord.addLogInfo("ModuleName", "MyModule");
        
            Logger logger = (Logger)Logger.getLogger(args[logName]);

            logger.log(logRecord, loggedByToken);

            System.out.println("LogSample: Logging Successful !!!");
	    System.exit(0);
	} catch (Exception ssoe) {
            System.err.println("LogSample: SSOException: " + ssoe.getMessage());
            System.err.println("LogSample: Logging Failed !!!");
        }
    }

    static SSOToken getSessionToken(String orgName, String userId,
	String password) throws Exception {
        AuthContext ac = null;
        try {
            ac = new AuthContext(orgName);
            ac.login();
        } catch (LoginException le) {
            le.printStackTrace();
            return null;
        }
       
        try { 
            Callback[] callbacks = null;
            // Get the information requested by the plug-ins
            if (ac.hasMoreRequirements()) {
                callbacks = ac.getRequirements();
                
                if (callbacks != null) {
                    addLoginCallbackMessage(callbacks, userId, password);
                    ac.submitRequirements(callbacks);
                    
                    if (ac.getStatus() == AuthContext.Status.SUCCESS) {
                        System.out.println("Auth success");
                    } else if (ac.getStatus() == AuthContext.Status.FAILED) {
                        System.out.println("Authentication has FAILED");
                    } else {
                    }
                } else {
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        SSOTokenManager.getInstance().validateToken(ac.getSSOToken());
        //System.out.println(ac.getSSOToken().getPrincipal().getName());
        return ac.getSSOToken();
    } 
    
    static void addLoginCallbackMessage(Callback[] callbacks, String userId,
        String password) throws UnsupportedCallbackException {
        int i = 0;
        try {
            for (i = 0; i < callbacks.length; i++) {
                if (callbacks[i] instanceof NameCallback) {

                    // prompt the user for a username
                    NameCallback nc = (NameCallback) callbacks[i];
                    nc.setName(userId);
                    
                } else if (callbacks[i] instanceof PasswordCallback) {

                    // prompt the user for sensitive information
                    PasswordCallback pc = (PasswordCallback) callbacks[i];

                    //System.out.println("password=" + password);
                    pc.setPassword(password.toCharArray());                    
                } else {
                }
            }
        } catch (Exception e) {
             throw new UnsupportedCallbackException(callbacks[i], 
                   "Callback exception: " + e);
        }
    }
}
