<%--
    Copyright (c) 2005 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>



<%@ page language="java" 
import="java.util.*,
java.io.*,
com.iplanet.sso.SSOToken,
com.iplanet.sso.SSOTokenManager,
com.iplanet.sso.SSOException"
%>

<%
    ResourceBundle properties = null;
    try { 
        String serverName = System.getProperty("server.name");
        String fname = null;
        if (serverName != null) {
            fname = "IDP1Config-" + serverName;
        } else {
            fname = "IDP1Config";
        }
        properties = ResourceBundle.getBundle(fname);
    } catch (Exception e) {
        try {
            response.sendError(response.SC_INTERNAL_SERVER_ERROR,
                               e.getMessage());
        } catch(IOException ignore) {
        }
    }

    String gotoUrl = HttpUtils.getRequestURL(request).toString();
    boolean loggedIn = false;
    try {
        SSOTokenManager manager = SSOTokenManager.getInstance();
        SSOToken ssoToken = manager.createSSOToken(request);
        if(ssoToken != null && manager.isValidToken(ssoToken)) {
            loggedIn = true;
        }
    } catch (com.iplanet.sso.SSOException e) {
    }

    if(!loggedIn) {
        String qs = request.getQueryString();
        if (qs != null && qs.length() > 0) {
            gotoUrl = gotoUrl + "?" + qs;
        } 
        response.sendRedirect(properties.getString(
            "com.sun.identity.federation.client.samples.preLoginURL")
            + "&goto=" + java.net.URLEncoder.encode(gotoUrl));
        return;
    }

%>
