/**
 * $Id: TabTwoViewBean.java,v 1.6 2005/06/24 16:50:34 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


package com.iplanet.am.console.user;

import com.iplanet.am.console.components.view.html.TabPane;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;

/**
 * This is a sample that demonstrates how to customize the user profile 
 * display with a tabbed interface. The only component used in this interface
 * is the <code>TabPane</code> component. The rest of the page uses standard
 * HTML. This sample also demonstrates the ability to extend the user profile
 * view. A more detailed example on that can be found in the <code>User
 * Profile</code> example.
 */
public class TabTwoViewBean extends UMUserProfileViewBean {

    /**
     * name of component in JSP.
     */
    public static final String TAB_PANE = "TabPane";
    
    public TabTwoViewBean() {
        super("TabTwo", "/console/user/TabTwo.jsp");
    }

    protected View createChild(String name) {
	if (name.equals(TAB_PANE)) {
	    return new TabPane(this, TAB_PANE, "");
	}
        return super.createChild(name);
    }

    protected void registerChildren() {
	registerChild(TAB_PANE, TabPane.class);
        super.registerChildren();
    }

    /**
     * This method is invoked by the framework when the page is rendered.
     * Here we can set the default values for any components.
     */
    public void beginDisplay(DisplayEvent event)
        throws ModelControlException
    {
	super.beginDisplay(event);

        // create the tab views
	OptionList optList = new OptionList();
        optList.add("Personal Data", "personal");
        optList.add("Work Information", "work");
        optList.add("General", "general");

	TabPane tabPane = (TabPane) getDisplayField(TAB_PANE);
	tabPane.setOptions(optList);
        tabPane.setValue("work");
    }

    /**
     * This is the event handler method for a tab. When a tab is selected 
     * this is the first method invoked. Based on the values from the event
     * the appropriate actions will be decided and taken from here.
     *
     * @param event request invocation event
     */
    public void handleTabPaneRequest(RequestInvocationEvent event) {
        RequestContext rc = getRequestContext();
        String view = (String)getDisplayFieldValue(TAB_PANE);
        ViewBean vb = null; 
 
        if (view.equals("personal")) { 
            vb = getViewBean(TabOneViewBean.class); 
        } else if (view.equals("work")) { 
            vb = getViewBean(TabTwoViewBean.class); 
        } else if (view.equals("general")) {
            vb = getViewBean(TabThreeViewBean.class);
        } else {    
            // default to misc tab 
            vb = getViewBean(TabOneViewBean.class); 
        } 

	passPgSessionMap(vb);
	vb.forwardTo(rc);
    }
}
