/**
 * $Id: SampleAMAuthCallBack.java,v 1.2 2005/06/24 16:53:00 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


package com.iplanet.am.samples.authentication.spi.statuschangedcallback; 

import com.sun.identity.authentication.spi.AMAuthCallBack;
import com.sun.identity.authentication.spi.AMAuthCallBackException;
import com.iplanet.am.util.Debug;

/**
 * This is a sample class which can be used to demonstrate the
 * callback implementation for authentication event types, such
 * as password changes (after reset), user lockout and failed
 * authentication attempts.
 * This class extends <code>AMAuthCallBack</code> and provides
 * a very simple example of how to use the information provided
 * during a callback. Additional business processing can be
 * performed based on requirements
 */
public class SampleAMAuthCallBack implements AMAuthCallBack {
    
    private Debug debug = Debug.getInstance("AuthCallBackSample");

    /** Creates a new instance of SampleAMAuthCallBack */
    public SampleAMAuthCallBack() {
        if (debug.messageEnabled()) {
            debug.message("SampleAuthCallBack : starting...");
        }
    }
    
    public void authEventCallback(int eventType, java.util.Map eventParams)
        throws AMAuthCallBackException
    {
        if (debug.messageEnabled()) {
            debug.message("authEventCallback : callback generated...");
            debug.message("authEventCallback : event type = " + eventType);
            debug.message("authEventCallback : parameters = " + eventParams);
        }
    }
}
