/**
 * $Id: LoginModuleSample.java,v 1.4 2005/06/24 16:52:57 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


package com.iplanet.am.samples.authentication.spi.providers;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;

public class LoginModuleSample extends AMLoginModule {

    private String userTokenId;
    private String userName;
    private String lastName;
    private java.security.Principal userPrincipal = null;
    private static final String LOGIN_USER = "anonymous";

    public LoginModuleSample() throws LoginException{
	System.out.println("LoginModuleSample()");
    }

    public void init(Subject subject, Map sharedState, Map options) {
	System.out.println("LoginModuleSample initialization");
    } 

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
	int currentState = state;

	if (currentState == 1) {
	    userName = ((NameCallback) callbacks[0]).getName();
	    lastName =  ((NameCallback) callbacks[1]).getName();
	    if (userName.equals("") || lastName.equals("")) {
		throw new AuthLoginException("names must not be empty");
	    }
	    return 2;
	} else if (currentState == 2) {
	    System.out.println("Replace TExt first: " + userName + 
                " last: " + lastName);
            // set #REPLACE# text in next state
            Callback[] callbacks2 = getCallback(3);
            String msg = ((NameCallback)callbacks2[0]).getPrompt();
            int i = msg.indexOf("#REPLACE#");
            String newMsg = msg.substring(0, i) + userName +
                msg.substring(i+9);
            replaceCallback(3, 0, new NameCallback(newMsg));
            // set #REPLACE# in password callback
            msg = ((PasswordCallback)callbacks2[1]).getPrompt();
            i = msg.indexOf("#REPLACE#");
            newMsg = msg.substring(0, i) + lastName + msg.substring(i+9);
            replaceCallback(3, 1, new PasswordCallback(newMsg, false));
	    return 3;
	} else if (currentState == 3) {
            int len = callbacks.length;
	    for (int i=0; i<len; i++) {
                if (callbacks[i] instanceof NameCallback) {
		    System.out.println("Callback Prompt-> " + 
                        ((NameCallback) callbacks[i]).getPrompt());
                } else if (callbacks[i] instanceof PasswordCallback) {
		    System.out.println("Callback Prompt-> " + 
                        ((PasswordCallback) callbacks[i]).getPrompt());
                }
	    }
	    return 4;
	} else if (currentState == 4) {
            int len = callbacks.length;
	    for (int i=0; i<len; i++) {
                if (callbacks[i] instanceof NameCallback) {
		    System.out.println("Callback Value-> " + 
                        ((NameCallback) callbacks[i]).getName());
                } else if (callbacks[i] instanceof PasswordCallback) {
		    System.out.println("Callback Value-> " + 
                        ((PasswordCallback) callbacks[i]).getPassword());
                }
	    }
	    userTokenId = LOGIN_USER;
            // return -1 for login successful
	    return -1;
	}
        throw new AuthLoginException("Invalid state : " + currentState);
    }

    public java.security.Principal getPrincipal() {
        if (userPrincipal != null) {
            return userPrincipal;
        } else if (userTokenId != null) {
            userPrincipal = new SamplePrincipal(userTokenId);
            return userPrincipal;
        } else {
            return null;
        }
    }
}
