/**
 * $Id: UserIDGeneratorSample.java,v 1.2 2005/06/24 16:52:53 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


package com.iplanet.am.samples.authentication.spi.genuid;

import java.util.*;
import com.sun.identity.authentication.spi.UserIDGenerator;

/**
 *
 * The <code>UserIDGeneratorSample</code> sample implements
 * <code>UserIDGenerator</code> interface to generate a set of
 * user IDs based on the first name and last name of the user.
 */
public class UserIDGeneratorSample implements UserIDGenerator {
    
    private static final String ATTRIBUTE_FIRST_NAME = "givenname";
    private static final String ATTRIBUTE_LAST_NAME = "sn";
    private static final String EMPTY_STRING = "";
        
    /**
     * Generates a set of user IDs.
     * The parameter num refers to the maximum number of user IDs
     * returned. It is possible that the size of the returned
     * <code>Set</code> is smaller than the parameter num.
     *
     * @param orgName the DN of the organization
     * @param attributes the keys in the <code>Map</code> contains the
     *                   attribute names and their corresponding values in
     *                   the <code>Map</code> is a <code>Set</code> that
     *                   contains the values for the attribute
     * @param num the maximum number of returned user IDs; 0 means there
     *            is no limit
     * @return a set of auto-generated user IDs
     */
    public Set generateUserIDs(String orgName, Map attributes, int num) {
        Set userIDs = new HashSet();
        
        String lastName = getAttributeValue(
        attributes, ATTRIBUTE_LAST_NAME).toLowerCase();
        String firstName = getAttributeValue(
        attributes, ATTRIBUTE_FIRST_NAME).toLowerCase();
        
        if (firstName.equals(EMPTY_STRING) || lastName.equals(EMPTY_STRING)) {
            return userIDs;
        }
        
        userIDs.add(firstName + lastName + "-SAMPLE");
        userIDs.add(lastName + firstName + "-SAMPLE");
                        
        if (num == 0) {
            return userIDs;            
        } else {
            return returnSet(userIDs, num);
        }
    }
    
    private String getAttributeValue(Map attrs, String attrName) {
        Set values = (Set) attrs.get(attrName);
        if (values != null) {
            Iterator it = values.iterator();
            if (it.hasNext()) {
                return ((String) it.next());
            }
        }
        return EMPTY_STRING;
    }
    
    private Set returnSet(Set origSet, int num) {
        if (num < 0) {
            return Collections.EMPTY_SET;
        }
        
        if (num < origSet.size()) {
            Iterator it = origSet.iterator();
            Set newSet = new HashSet();
            for (int i = 0; i < num; i++) {
                newSet.add((String) it.next());
            }
            return newSet;
        }
        
        return origSet;
    }
}
