/**
 * $Id: JCDILogin.java,v 1.4 2005/06/24 16:52:52 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


import java.io.*;
import java.util.*;
import java.net.*;

import java.security.Principal;
import javax.security.auth.*;
import javax.security.auth.login.*;
import javax.security.auth.callback.*;

import com.sun.identity.authentication.AuthContext;

public class JCDILogin {
    
    static String indexName = "";
    static AuthContext.IndexType indexType;
    static String orgName = "";
    static String CertFile="";
    static String SerialFile="";
    static boolean debug = true;
    
    static AuthContext lc = null;
            
    public static  void main(String[] args) {
        
        String strCert = null;
        String strSerial = null;
        String strSso = null;

	orgName = args[0];
        debugMessage("orgname is : " + orgName);

	CertFile = args[1];
	debugMessage("Certificate file is : " + CertFile);
	
	SerialFile = args[2];
	debugMessage("Serial file is : " + SerialFile);
            
        try {
            
            FileInputStream filecert = new FileInputStream(CertFile);
            FileInputStream fileserial = new FileInputStream(SerialFile);
            
            int certsize = filecert.available();
            int serialsize = fileserial.available();
            
            if ((certsize==0) || (serialsize==0)) {
                debugMessage("Files size empty");
                System.exit(1);
            }
            
            byte cert[] = new byte[certsize];
            byte serial[] = new byte[serialsize];
            
            filecert.read(cert, 0, certsize);
            fileserial.read(serial, 0, serialsize);
    
            strCert = new String(cert);
            strSerial = new String(serial);
        }
        catch (Exception e1) {
            
            if (e1 instanceof FileNotFoundException)
                debugMessage("JCDILogin: Files not found - asking for authentication");
            if (e1 instanceof IOException)  
                debugMessage("JCDILogin: IO error - asking for authentication");
        }
        
        
        // Start the authentication process
        try {
            
            // Create the context
            lc = new AuthContext(orgName);
            indexType = AuthContext.IndexType.MODULE_INSTANCE;
            indexName = "JCDI";
            debugMessage("JCDILogin: Obtained login context");
            lc.login(indexType, indexName);
            
        } catch (LoginException le) {
            le.printStackTrace();
            debugMessage("Login failed!!" + le.toString());
            return;
        }
           
        // Try to authenticate
        try {
            processLogin(strCert, strSerial);
        }
        catch (Exception e3) {
            debugMessage("Login has failed!!" + e3.toString());
        }
    
	
        // Check the authentication 
	if (lc.getStatus() == AuthContext.Status.SUCCESS) {
	    debugMessage("Login success!!");
	} else if (lc.getStatus() == AuthContext.Status.FAILED) {
	    debugMessage("Login has failed!!");
	} else {
	    debugMessage("Unknown status: " + lc.getStatus());
	}
        
	System.exit(0);
    }

    // get user's inputs and set them to callback array.
    static void processLogin(String cert, String serial) throws Exception {
        
        debugMessage("begin processLogin");
        
        // Get Login requirements
        Callback[] callbacks = null;
        
        // get information requested from module
        callbacks = lc.getRequirements();
        debugMessage("getRequirements done 1");
        if (callbacks != null) {
            
            try {           
                // prompt the user for a serial number
                debugMessage("Serial is = " + serial);
                NameCallback ncSerial = (NameCallback)callbacks[0];
                ncSerial.setName(serial);
              
                // prompt the user for the certificate
                debugMessage("Cert is = " + cert);
                NameCallback ncCert = (NameCallback) callbacks[1];
                ncCert.setName(cert);
                 
                lc.submitRequirements(callbacks);
                debugMessage("submitRequirements done 1");
                
                callbacks = lc.getRequirements();
                debugMessage("getRequirements done 2");
                
                if (callbacks != null) {
                    NameCallback ncUserName = (NameCallback) callbacks[0];
                    debugMessage("UserName is = " + ncUserName.getPrompt());

                    ncUserName.setName("");
                    lc.submitRequirements(callbacks);
                    debugMessage("submitRequirements done 2");
                }
                
            } catch (Exception e) {
                debugMessage("Login failed!!" + e.toString());
                return;
            }
        }
    }

    static void debugMessage(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

}
        
