/**
 * $Id: CertLogin.java,v 1.4 2005/06/24 16:52:49 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


import java.net.URL;
import com.sun.identity.authentication.AuthContext;

public class CertLogin {
    static String indexName = "Cert";
    static AuthContext.IndexType indexType;
    static String USAGE_CERT_LOGIN = 
           "gmake run DOMAIN=\"dc=example,dc=com\" CERTNICKNAME=\"tester's cert\" URL=\"https://example.com:54430\" PASSWORD=password\n";
    
    public static  void main(String[] args) {
        // Initialize DSAMELoginContext
        AuthContext lc = null;
    	String orgName, certNickName, serverURL, password;

    	if (args.length < 4) {
            displayUsage();
    	}

        orgName = args[0];
        certNickName = args[1];
        serverURL = args[2];
        password = args[3];

        /**
         * This method sets the password for the certificate db.
         * It is required to call only once to initialize certificate db if
         * the password is not set in the password file (specified as
         * the value for "com.iplanet.am.admin.cli.certdb.passfile"
         * in AMConfig.properties). If both are set, this method will
         * overwrite the value in certificate password file.
        **/
        AuthContext.setCertDBPassword(password); 

        try {
            URL url = new URL(serverURL);
            lc = new AuthContext(orgName, certNickName, url);

            indexType = AuthContext.IndexType.MODULE_INSTANCE;
            System.out.println("CertLogin: Obtained login context");
            lc.login(indexType, indexName);

            if (lc.getStatus() == AuthContext.Status.SUCCESS) {
                System.out.println("LOGIN SUCCESS");
                lc.logout();
                System.out.println("LOGGED OUT");
            } else {
                System.out.println("LOGIN FAILED");
            }
        } catch (Exception le) {
            le.printStackTrace();
            System.out.println("LOGIN FAILED");
            System.exit(0);
        }
    }

    static void displayUsage() {
        System.out.println(USAGE_CERT_LOGIN);
        System.exit(0);
    }
}
