# 
# PROPRIETARY/CONFIDENTIAL. Use of this product is subject to license terms. 
# Copyright 2002 Sun Microsystems, Inc. All rights reserved. 
# 
# This Perl script will create an LDIF file that can be used to update the individual
# user entries within the DIT. It is to be used on an existing tree when installing 
# Sun Java System Access Manager. If you are installing Sun Java System Access Manager against a clean directory 
# server, this script is not necessary. If you are unsure of the necessary steps, 
# please read the README file.
# 
# This script must be run from <DS install root>/shared/bin
#
# Before running this script, you need to define the base root at $base.
#
#  - base root which Sun Java System Access Manager is being installed against
$base = "ROOT_SUFFIX";

#set these variables to the path of your ldapsearch and ldapmodify commands.
$LDAP_SEARCH="/opt/SUNWam/bin/ldapsearch";
$LDAP_MODIFY="/usr/iplanet/servers/shared/bin/ldapmodify";


sub readInput {
    my ($message, $datatype, $defaultvalue) = @_;

    $datatype = 'String' if $datatype eq '';

    $correct = 'true';
    do {
        if($defaultvalue eq '') {
            print "$message:";
        } else {
            print "$message \[$defaultvalue]:";
        }

        $_ = <STDIN>;
        chomp;

        # Check if the data type is correct
        if($datatype eq 'String') {
            if($_ eq '') {
                if($defaultvalue eq '') {
                    if($#_ < 2) {
                        $correct = 'false';
                    } else {
                        $correct = 'true';
                    }
                } else {
                    $correct = 'true';
                    $_ = $defaultvalue;
                }
            } else {
                $correct = 'true';
            }
        }

        if($datatype eq 'Integer') {
            if($_ eq '') {
                if($defaultvalue eq '') {
                    $correct = 'false';
                } else {
                    $correct='true';
                    $_ = $defaultvalue;
                }
            } else {
                if(/\D/) {
                    $correct = 'false';
                } else {
                    $correct = 'true';
                }
            }
        }

        if($datatype eq 'Password') {
            if($_ eq '') {
                if($defaultvalue eq '') {
                    if($#_ < 2) {
                        $correct = 'false';
                        print "\n";
                    } else {
                        $correct = 'true';
                    }
                } else {
                    $_ = $defaultvalue;
                }
            } else {
                $correct = 'true';
            }
        } else {
            $correct = 'true';
        }
    } until ($correct eq 'true');
    $_;
}

#  - bind credentials with full read capability against existing directory server
#

$host = readInput('Enter Host name', 'String', 'DIRECTORY_SERVER');
$bind_user = readInput('Enter Bind User name', 'String', 'cn=directory manager');
$bind_pwd = readInput('Enter Bind password', 'Password', '');
$port = readInput('Enter port number', 'Integer', 'DIRECTORY_PORT');

# Start of main program
#
# run search to find all users, putting their DNs in to a file
system("$LDAP_SEARCH -h \"$host\" -p \"$port\" -D \"$bind_user\" -w \"$bind_pwd\" -b \"$base\" -T \"(objectclass=USER_OBJECT_CLASS)\" dn > users.dn");

# open DN file for reading
open (stdin, "users.dn") || die "can't open listing of user DNs $!";
open (UUL, ">users-updated.ldif");

while (<>) {

  $line = $_;
  chomp ($line);

  ($attribute, $the_rest) = split (/\:/, $line);
  ($uid, $p_or_g, $domain, $affiliates, $siroe, $messaging, $root) = split (/,/, $the_rest);
  

  # remove the 'ou=' from before the actual domain value
  ($garbage, $final_domain) = split (/=/, $domain);

  #print "y$final_domain" . "y\n";

  if ($attribute eq "dn") {
    print UUL "$line\n";
    print UUL "changetype: modify\n";
    print UUL "add: objectclass\n";
    print UUL "objectclass: inetuser\n"; 
    print UUL "objectclass: inetadmin\n"; 
    print UUL "objectclass: iplanet-am-managed-person\n"; 
    print UUL "objectclass: iplanetPreferences\n"; 
    print UUL "objectclass: iplanet-am-user-service\n"; 
    print UUL "-\n";
    print UUL "add: inetUserStatus\n";
    print UUL "inetUserStatus: Active\n";
    print UUL "\n";
  }
}

#close();
close UUL;
#system("$LDAP_MODIFY -h'$host' -p'$port' -D'$bind_user' -w'$bind_pwd' -a -c -f users-updated.ldif");
