/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMMenuValidator;
import com.iplanet.am.console.base.model.AMMenuValidatorImpl;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMUserModelImpl;
import com.iplanet.am.console.user.model.UMUserViewModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMUserViewModelImpl
extends UMUserModelImpl
implements UMUserViewModel {
    protected boolean showUserRoles = false;
    protected boolean showUserGroups = false;
    protected boolean userGroupSubscribe = false;
    protected String userServiceDisplay = "UserOnly";
    protected Set values = null;

    public UMUserViewModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        AMModelBase.debug.message("UMUserViewModelImpl map " + map);
        this.getUserDisplayAttrs();
    }

    public Set getServicesMenu() {
        Set set = this.getServicesForUser();
        if (this.isCombinedDisplay()) {
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.hasSchemaType(string, SchemaType.USER)) continue;
            hashSet.add(string);
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("UMUserViewModelImpl.getServicesMenu " + hashSet);
        }
        return hashSet;
    }

    protected Set excludedObjFromSet(Set set, Set set2) {
        HashSet hashSet = new HashSet(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (set2.contains(e)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    public boolean getShowUserRoleFlag() {
        return this.showUserRoles;
    }

    public boolean getShowUserGroupFlag() {
        return this.showUserGroups;
    }

    public boolean getUserGroupSubscribe() {
        return this.userGroupSubscribe;
    }

    public boolean isCombinedDisplay() {
        return this.userServiceDisplay.equalsIgnoreCase("Combined");
    }

    private void getUserDisplayAttrs() {
        AMTemplate aMTemplate = this.getOrgTemplate(this.getAuthenticatedOrg());
        if (aMTemplate != null) {
            this.getUserDispAttrsFromTemplate(aMTemplate);
        } else {
            this.getUserDispAttrsFromSchema();
        }
    }

    private void getUserDispAttrsFromTemplate(AMTemplate aMTemplate) {
        try {
            this.userServiceDisplay = AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-user-service-display");
            if (this.getUserType() == 3) {
                this.showUserRoles = AMAdminUtils.getBooleanAttribute(aMTemplate, "iplanet-am-admin-console-user-role-display");
                this.showUserGroups = AMAdminUtils.getBooleanAttribute(aMTemplate, "iplanet-am-admin-console-user-groups-display");
                this.userGroupSubscribe = AMAdminUtils.getBooleanAttribute(aMTemplate, "iplanet-am-admin-console-user-groups-subscribe");
            } else {
                this.showUserRoles = true;
                this.showUserGroups = true;
                this.userGroupSubscribe = true;
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserViewModelImpl.getUserDispAttrsFromTemplate", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("UMUserViewModelImpl.getUserDispAttrsFromTemplate", (Throwable)aMException);
        }
    }

    private void getUserDispAttrsFromSchema() {
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
            this.userServiceDisplay = AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-service-display");
            if (this.getUserType() == 3) {
                this.showUserRoles = AMAdminUtils.getBooleanAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-role-display");
                this.showUserGroups = AMAdminUtils.getBooleanAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-groups-display");
                this.userGroupSubscribe = AMAdminUtils.getBooleanAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-groups-subscribe");
            } else {
                this.showUserRoles = true;
                this.showUserGroups = true;
                this.userGroupSubscribe = true;
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("UMUserViewModelImpl.getUserDispAttrsFromSchema", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserViewModelImpl.getUserDispAttrsFromSchema", (Throwable)sSOException);
        }
    }

    private boolean hasSchemaType(String string, SchemaType schemaType) {
        boolean bl = false;
        try {
            ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string);
            Set set = serviceSchemaManager.getSchemaTypes();
            bl = AMAdminUtils.containsSchemaType(set, schemaType);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserViewModelImpl.hasSchemaType", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.error("UMUserViewModelImpl.hasSchemaType", (Throwable)sMSException);
        }
        return bl;
    }

    public String getUserRoleLabel() {
        return this.getLocalizedString("userRoles.label");
    }

    public String getUserGroupLabel() {
        return this.getLocalizedString("userGroups.label");
    }

    public String getSelectLabel() {
        return this.getLocalizedString("select.label");
    }

    public String getGeneralUserViewLabel() {
        return this.getLocalizedString("showUserProfile.label");
    }

    public String getErrorTitle() {
        return this.getLocalizedString("userProfileError.title");
    }

    public String getGenericErrorMessage() {
        return this.getLocalizedString("userProfileError.message");
    }

    public String getAvailableServiceLabel() {
        return this.getLocalizedString("registeredServices.label");
    }

    public String getNameLabel() {
        return this.getLocalizedString("name.label");
    }

    public String getAssignedLabel() {
        return this.getLocalizedString("assigned.label");
    }

    public String getShowMenuLabel() {
        return this.getLocalizedString("view.label");
    }

    public boolean isServiceAssigned(String string) {
        return this.getServicesForUser().contains(string);
    }

    public String getUserNotSetMessage() {
        return this.getLocalizedString("curUserNotSet.message");
    }

    public String getNoEntriesMsg() {
        return this.getLocalizedString("noEntries.message");
    }

    public Set getAttrList() {
        return this.values;
    }

    public void setAttrList(Set set) {
        this.values = set;
    }

    public String getRowsLabel() {
        return this.getLocalizedString("rows.label");
    }

    public String getRowLabel() {
        return this.getLocalizedString("row.label");
    }

    protected Set getObjAssignNotInCurPage(List list, Set set) {
        if (set == null || set.isEmpty() || list == null || list.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet hashSet = new HashSet(set);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            if (hashSet.remove(e) && hashSet.isEmpty()) break;
            ++n2;
        }
        return hashSet;
    }

    protected Set convertToOrderedSet(Set set) {
        if (set == null || set.isEmpty() || set instanceof OrderedSet) {
            return set;
        }
        OrderedSet orderedSet = new OrderedSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            orderedSet.add(iterator.next());
        }
        return orderedSet;
    }

    public boolean isPrimaryTitle() {
        int n = this.getLocationType();
        return n == 2 || n == 3 || n == 5;
    }

    public String getDefaultSubView() {
        String string = null;
        Set set = this.getUserSettings(Setting.DEFAULT_USER_PROFILE_VIEW);
        if (set != null && !set.isEmpty()) {
            string = (String)set.iterator().next();
        }
        if (string == null || string.length() == 0) {
            string = "iPlanetAMUserService".toLowerCase();
        }
        return string;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("userProfile.help");
        if (string.equals("userProfile.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public Class getUserProfileViewBeanClass() {
        return this.getUserProfileViewBeanClass(this.curUserDN);
    }

    public Set getVisibleSubViewShowMenu() {
        AMMenuValidator aMMenuValidator = AMMenuValidatorImpl.getInstance();
        return aMMenuValidator.getUserProfileMenuOptions(this);
    }

    public String getUserDN() {
        return this.curUser.getDN();
    }

    public String getLocalizedSvcName(String string) {
        return this.getLocalizedServiceName(string);
    }

    public String getResourceOfferingLabel() {
        return this.getLocalizedString("userResourceOffering.label");
    }
}

