/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMUserServiceAddModel;
import com.iplanet.am.console.user.model.UMUserViewModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.sso.SSOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMUserServiceAddModelImpl
extends UMUserViewModelImpl
implements UMUserServiceAddModel {
    private boolean servicesAssigned = false;

    public UMUserServiceAddModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("services.header");
    }

    public void updateServices(Set set) throws AMConsoleException {
        if (this.curUser == null || !this.isAdministrator()) {
            return;
        }
        Set set2 = this.getServicesForUser();
        set2.remove("iPlanetAMUserService");
        if (set2.equals(set)) {
            AMModelBase.debug.message("the list of services did not change");
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        Set set3 = this.excludedObjFromSet(set, set2);
        if (set3 != null && !set3.isEmpty()) {
            if (AMModelBase.debug.messageEnabled()) {
                AMModelBase.debug.message("adding " + set3 + " to user services");
            }
            try {
                this.curUser.assignServices(set3);
                this.servicesAssigned = true;
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append(this.getLocalizedString("assignedServicesToUser.message")).append(" " + this.curUser.getDN()).append(":" + set3);
                this.logger.doLog(stringBuffer.toString());
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("assigning services to user", (Throwable)aMException);
                arrayList.add(this.getErrorString((Exception)((Object)aMException)));
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("assigning services to user ", (Throwable)sSOException);
                arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
            }
        }
        if (!arrayList.isEmpty()) {
            throw new AMConsoleException(arrayList);
        }
    }

    public String getSuccessMessage() {
        if (this.servicesAssigned) {
            return this.getLocalizedString("updateUser.message");
        }
        return this.getLocalizedString("noChangesMade.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("userServiceAdd.help");
        if (string.equals("userServiceAdd.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }
}

