/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMUserRoleSelectModel;
import com.iplanet.am.console.user.model.UMUserViewModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.sso.SSOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.util.DN;

public class UMUserRoleSelectModelImpl
extends UMUserViewModelImpl
implements UMUserRoleSelectModel {
    private Set roles = null;
    private boolean rolesModified = false;
    private int errorCode = 0;
    private String errorMessage = null;
    private String errorTitle = null;

    public UMUserRoleSelectModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public Set getUserRoleDNs() {
        Set set = Collections.EMPTY_SET;
        try {
            if (this.curUser != null) {
                set = this.curUser.getRoleDNs();
            }
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMUserRoleSelectModelImpl.getUserRoleDNs", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserRoleSelectModelImpl.getUserRoleDNs", (Throwable)aMException);
        }
        if (set == null) {
            set = Collections.EMPTY_SET;
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    if (this.getObjectType(string) == 6) continue;
                    if (AMModelBase.debug.warningEnabled()) {
                        AMModelBase.debug.warning("removing " + string + " from the " + "users role list. It is not an IS role.");
                    }
                    iterator.remove();
                }
                catch (AMException aMException) {
                    iterator.remove();
                    if (!AMModelBase.debug.warningEnabled()) continue;
                    AMModelBase.debug.warning("removing " + string + " from the user role list (" + aMException.getMessage() + ")");
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.warning("invalid sso token getting users roles");
                }
            }
        }
        return set;
    }

    public String getNoRolesAvailableMsg() {
        return this.getLocalizedString("noAddRoleEntries.message");
    }

    public Set getRoles(String string) {
        AMOrganization aMOrganization;
        Set set = this.getUserRoleDNs();
        if (this.isAdministrator() && (aMOrganization = this.getUserOrg()) != null) {
            try {
                AMSearchControl aMSearchControl = new AMSearchControl();
                aMSearchControl.setSearchScope(1);
                this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                AMSearchResults aMSearchResults = aMOrganization.searchRoles(string, aMSearchControl);
                if (aMSearchResults == null) {
                    AMModelBase.debug.warning("UMUserRoleSelectImpl.getRoles: search for roles returned null");
                    this.roles = set;
                } else {
                    this.combineRoles(set, aMSearchResults.getSearchResults());
                    this.errorCode = aMSearchResults.getErrorCode();
                    this.errorMessage = AMAdminUtils.getSearchResultWarningMessage(aMSearchResults, this);
                    this.errorTitle = AMAdminUtils.getSearchResultWarningTitle(aMSearchResults, this);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMUserRoleSelectModelImpl.getRoles", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMUserRoleSelectModelImpl.getRoles", (Throwable)aMException);
            }
        }
        this.roles = this.convertToOrderedSet(set);
        return this.roles;
    }

    public boolean displaySearchMessage() {
        return this.errorCode != 0;
    }

    public String getSearchMessageTitle() {
        return this.errorTitle != null ? this.errorTitle : "";
    }

    public String getSearchMessage() {
        return this.errorMessage != null ? this.errorMessage : "";
    }

    public void updateRoles(Set set) throws AMConsoleException {
        if (this.curUser == null || !this.isAdministrator()) {
            return;
        }
        Set set2 = this.getUserRoleDNs();
        Set set3 = this.excludedObjFromSet(set2, set);
        Set set4 = this.excludedObjFromSet(set, set2);
        this.removeRoles(set3);
        this.addRoles(set4);
    }

    public void removeRoles(Set set) throws AMConsoleException {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    this.curUser.removeRole(string);
                    this.rolesModified = true;
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append(this.getLocalizedString("removedUserFromRole.message")).append(" " + string).append(":[" + this.curUser.getDN() + "]");
                    this.logger.doLog(stringBuffer.toString());
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("failed to remove role from user", (Throwable)aMException);
                    arrayList.add(this.getErrorString((Exception)((Object)aMException)));
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.warning("failed to remove role from user", (Throwable)sSOException);
                    arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
                }
            }
        }
        if (!arrayList.isEmpty()) {
            throw new AMConsoleException(arrayList);
        }
    }

    public String getRoleDisplayName(String string) {
        return AMFormatUtils.DNToName(this, string, true);
    }

    public String getPropertiesLabel() {
        return this.getLocalizedString("viewRole.label");
    }

    public String getNoRoleMessage() {
        return this.getLocalizedString("roleNotFound.message");
    }

    private void combineRoles(Set set, Set set2) {
        if (set == null || set2 == null || set2.isEmpty()) {
            return;
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            String string = (String)iterator.next();
            DN dN = new DN(string);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext() && !bl) {
                String string2 = (String)iterator2.next();
                DN dN2 = new DN(string2);
                bl = dN.equals(dN2);
            }
            if (bl) continue;
            set.add(string);
        }
    }

    public String getSuccessMessage() {
        if (this.rolesModified) {
            return this.getLocalizedString("updateUser.message");
        }
        return this.getLocalizedString("noChangesMade.message");
    }

    public Set getAssignedRoles() {
        return this.getUserRoleDNs();
    }

    public String getNoRoleEntriesMsg() {
        String string = this.getLocalizedString("noRoleEntriesUser.message");
        if (this.isAdministrator()) {
            string = this.getLocalizedString("noRoleEntries.message");
        }
        return string;
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("userRoles.help");
        if (string.equals("userRoles.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getRoleNotSelectedMessage() {
        return this.getLocalizedString("roleNotSelected.message");
    }

    public String getRoleNotSelectedTitle() {
        return this.getLocalizedString("roleNotSelected.title");
    }

    private void addRoles(Set set) throws AMConsoleException {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    this.curUser.assignRole(string);
                    this.rolesModified = true;
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append(this.getLocalizedString("assignedUserToRole.message")).append(" " + string).append(":[" + this.curUser.getDN() + "]");
                    this.logger.doLog(stringBuffer.toString());
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("assigning roles to user", (Throwable)aMException);
                    arrayList.add(this.getErrorString((Exception)((Object)aMException)));
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("assigning roles to user", (Throwable)sSOException);
                    arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
                }
            }
        }
        if (!arrayList.isEmpty()) {
            throw new AMConsoleException(arrayList);
        }
    }

    public Set getUnAssignedRoles(String string) {
        Set set = this.excludedObjFromSet(this.getRoles(string), this.getUserRoleDNs());
        return set == null ? Collections.EMPTY_SET : set;
    }

    public String getDisplayRolesMessage() {
        return this.getLocalizedString("displayRoles.message");
    }

    public String getAddButtonLabel() {
        return this.getLocalizedString("dynGUIAddToList.button");
    }

    public String getRemoveButtonLabel() {
        return this.getLocalizedString("dynGUIRemoveFromList.button");
    }

    public String getDisplayEndUserRolesLabel() {
        return this.getLocalizedString("displayEndUserRoles.label");
    }

    public String getNoRolesAssignedMessage() {
        return this.getLocalizedString("noRolesAssigned.message");
    }
}

