/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.user.model.UMNavModelImpl;
import com.iplanet.am.console.user.model.UMUserNavModel;
import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMUserNavModelImpl
extends UMNavModelImpl
implements UMUserNavModel {
    protected Set users = null;
    private Map localizedAttrNames = null;

    public UMUserNavModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
    }

    public void setUsers(Set set) {
        this.users = set != null ? set : Collections.EMPTY_SET;
    }

    public Set getUsers(String string) {
        if (this.isServiceDenied("iPlanetAMUserService")) {
            this.users = Collections.EMPTY_SET;
            this.searchErrorMsg = this.getLocalizedString("userServiceDenied.message");
            return this.users;
        }
        if (this.users == null) {
            AMSearchResults aMSearchResults = null;
            AMSearchControl aMSearchControl = new AMSearchControl();
            aMSearchControl.setSearchScope(1);
            try {
                switch (this.locationType) {
                    case 2: {
                        AMPeopleContainer aMPeopleContainer = this.getDefaultPeopleContainer();
                        AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                        this.setSearchControlAttributes(this.locationDN, null, 1, aMSearchControl, "users");
                        this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                        if (aMPeopleContainer != null) {
                            aMSearchResults = aMPeopleContainer.searchUsers(aMSearchControl, this.getSearchFilter(this.locationDN, string));
                            break;
                        }
                        aMSearchResults = aMOrganization.searchUsers(aMSearchControl, this.getSearchFilter(this.locationDN, string));
                        break;
                    }
                    case 3: {
                        AMPeopleContainer aMPeopleContainer = this.getDefaultPeopleContainer();
                        AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                        this.setSearchControlAttributes(this.locationDN, null, 1, aMSearchControl, "users");
                        this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                        if (aMPeopleContainer != null) {
                            aMSearchResults = aMPeopleContainer.searchUsers(aMSearchControl, this.getSearchFilter(this.locationDN, string));
                            break;
                        }
                        aMSearchResults = aMOrganizationalUnit.searchUsers(aMSearchControl, this.getSearchFilter(this.locationDN, string));
                        break;
                    }
                    case 5: {
                        AMPeopleContainer aMPeopleContainer = this.dpStoreConn.getPeopleContainer(this.locationDN);
                        String string2 = aMPeopleContainer.getOrganizationDN();
                        this.setSearchControlAttributes(string2, null, 1, aMSearchControl, "users");
                        int n = this.getObjectType(string2);
                        if (n == 2) {
                            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string2);
                            this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                        } else {
                            AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string2);
                            this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                        }
                        aMSearchResults = aMPeopleContainer.searchUsers(aMSearchControl, this.getSearchFilter(string2, string));
                        break;
                    }
                    case 6: 
                    case 8: {
                        AMRole aMRole = (AMRole)this.getAMObject(this.locationDN);
                        String string3 = aMRole.getOrganizationDN();
                        this.setSearchControlAttributes(string3, null, 1, aMSearchControl, "users");
                        int n = this.getObjectType(string3);
                        if (n == 2) {
                            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string3);
                            this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                        } else {
                            AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string3);
                            this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                        }
                        aMSearchResults = aMRole.searchUsers(aMSearchControl, this.getSearchFilter(string3, string));
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        AMGroup aMGroup = (AMGroup)this.getAMObject(this.locationDN);
                        String string4 = aMGroup.getOrganizationDN();
                        this.setSearchControlAttributes(string4, null, 1, aMSearchControl, "users");
                        int n = this.getObjectType(string4);
                        if (n == 2) {
                            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(string4);
                            this.setSearchControlLimits((AMObject)aMOrganization, aMSearchControl);
                        } else {
                            AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(string4);
                            this.setSearchControlLimits((AMObject)aMOrganizationalUnit, aMSearchControl);
                        }
                        aMSearchResults = aMGroup.searchUsers(aMSearchControl, this.getSearchFilter(string4, string));
                        break;
                    }
                    default: {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("UMUserNavModelImpl.getManagedGroup invalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMUserNavModelImpl.getUsers", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMUserNavModelImpl.getUsers", (Throwable)aMException);
                this.searchErrorMsg = this.getErrorString((Exception)((Object)aMException));
            }
            this.users = Collections.EMPTY_SET;
            if (aMSearchResults != null) {
                this.users = this.getSearchResultsSet(aMSearchResults);
                this.resultsMap = aMSearchResults.getResultAttributes();
            }
        }
        return this.users;
    }

    public Map getResultsMap() {
        return this.resultsMap;
    }

    public void setResultsMap(Map map) {
        this.resultsMap = map == null ? new HashMap(0) : map;
    }

    public List getSearchReturnAttributes() {
        String string;
        block14: {
            if (this.searchReturnAttrs != null) {
                return this.searchReturnAttrs;
            }
            string = null;
            try {
                switch (this.locationType) {
                    case 2: {
                        string = this.getSearchReturnAttribute(this.locationDN);
                        break;
                    }
                    case 3: {
                        string = this.getSearchReturnAttribute(this.locationDN);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        AMGroup aMGroup = (AMGroup)this.getAMObject(this.locationDN);
                        string = this.getSearchReturnAttribute(aMGroup.getOrganizationDN());
                        break;
                    }
                    case 6: 
                    case 8: {
                        AMRole aMRole = (AMRole)this.getAMObject(this.locationDN);
                        string = this.getSearchReturnAttribute(aMRole.getOrganizationDN());
                        break;
                    }
                    case 5: {
                        AMPeopleContainer aMPeopleContainer = this.dpStoreConn.getPeopleContainer(this.locationDN);
                        string = this.getSearchReturnAttribute(aMPeopleContainer.getOrganizationDN());
                        break;
                    }
                    default: {
                        if (AMModelBase.debug.warningEnabled()) {
                            AMModelBase.debug.warning("UMUserNavModelImpl.getSearchReturnAttributes invalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException sSOException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("UMUserNavModelImpl.getSearchReturnAttributes", (Throwable)sSOException);
                }
            }
            catch (AMException aMException) {
                if (!AMModelBase.debug.warningEnabled()) break block14;
                AMModelBase.debug.warning("UMUserNavModelImpl.getSearchReturnAttributes", (Throwable)aMException);
            }
        }
        if (string == null) {
            this.searchReturnAttrs = new ArrayList(1);
            this.searchReturnAttrs.add(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug));
            return this.searchReturnAttrs;
        }
        this.searchReturnAttrs = this.getValidatedAttributes(string, null, 1, "users");
        return this.searchReturnAttrs;
    }

    public void setSearchReturnAttributes(String string) {
        this.searchReturnAttrs = this.getValidatedAttributes(string, null, 1, "users");
    }

    public String getSelectedOption() {
        return "users";
    }

    public boolean deleteUsers(Set set) {
        boolean bl = false;
        if (set != null) {
            if (this.isUserServiceDenied()) {
                this.setErrorMessage(this.getLocalizedString("userServiceDenied.message"));
                return bl;
            }
            try {
                Map map = this.deleteUMObject(1, set, "userDeleted.message");
                if (!map.isEmpty()) {
                    Iterator iterator = map.keySet().iterator();
                    this.setErrorMessage(this.getLocalizedString("deleteUserFailed.message"));
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = AMFormatUtils.DNToName(this, string, false);
                        String string3 = (String)map.get(string);
                        this.setErrorMessage(string2 + " - " + string3);
                    }
                } else {
                    bl = true;
                }
            }
            catch (AMConsoleException aMConsoleException) {
                this.setErrorMessage(this.getErrorString(aMConsoleException));
            }
        } else {
            this.setErrorMessage(this.getLocalizedString("deleteFailed.message"));
        }
        return bl;
    }

    public boolean removeUsers(Set set) {
        boolean bl = true;
        if (set != null) {
            if (this.isUserServiceDenied()) {
                this.setErrorMessage(this.getLocalizedString("userServiceDenied.message"));
                bl = false;
                return bl;
            }
            try {
                int n = this.getObjectType(this.locationDN);
                if (n == 9 || n == 10) {
                    AMStaticGroup aMStaticGroup = (AMStaticGroup)this.getAMObject(this.locationDN);
                    aMStaticGroup.removeUsers(set);
                    this.writeLog("removedUserFromGroup.message", aMStaticGroup.getDN(), set);
                } else if (n == 12) {
                    AMAssignableDynamicGroup aMAssignableDynamicGroup = (AMAssignableDynamicGroup)this.getAMObject(this.locationDN);
                    aMAssignableDynamicGroup.removeUsers(set);
                    this.writeLog("removedUserFromGroup.message", aMAssignableDynamicGroup.getDN(), set);
                } else if (n == 6) {
                    AMRole aMRole = (AMRole)this.getAMObject(this.locationDN);
                    aMRole.removeUsers(set);
                    this.writeLog("removedUserFromRole.message", aMRole.getDN(), set);
                } else {
                    bl = false;
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMUserNavModelImpl.removeUsers", (Throwable)sSOException);
                this.setErrorMessage(this.getLocalizedString("removeUsersError.message"));
                this.setErrorMessage(sSOException.getLocalizedMessage());
                bl = false;
            }
            catch (AMException aMException) {
                if (AMModelBase.debug.warningEnabled()) {
                    AMModelBase.debug.warning("UMUserNavModelImpl.removeUsers", (Throwable)aMException);
                }
                this.setErrorMessage(this.getLocalizedString("removeUsersError.message"));
                this.setErrorMessage(aMException.getLocalizedMessage());
                bl = false;
            }
        }
        return bl;
    }

    public String getAddBtnLabel() {
        return this.getLocalizedString("add.button");
    }

    public String getRemoveBtnLabel() {
        return this.getLocalizedString("remove.button");
    }

    public boolean showAddRemove() {
        return this.locationType == 6 || this.locationType == 9 || this.locationType == 10 || this.locationType == 12;
    }

    public boolean showCreateDelete() {
        return this.locationType != 6 && this.locationType != 8 && this.locationType != 11;
    }

    public boolean showSelect() {
        return this.locationType != 11 && this.locationType != 8;
    }

    public boolean isUserServiceDenied() {
        return this.isServiceDenied("iPlanetAMUserService");
    }

    public String getAttributeLocalizedName(String string) {
        String string2;
        if (this.localizedAttrNames == null) {
            this.localizedAttrNames = this.getLocalizedAttributes();
        }
        if ((string2 = (String)this.localizedAttrNames.get(string)) == null) {
            string2 = string;
        }
        return string2;
    }

    public String getAttributeLocalizedName() {
        this.getSearchReturnAttributes();
        if (this.searchReturnAttrs.isEmpty()) {
            return this.getAttributeLocalizedName(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug));
        }
        int n = this.searchReturnAttrs.size();
        return this.getAttributeLocalizedName((String)this.searchReturnAttrs.get(n - 1));
    }

    private Map getLocalizedAttributes() {
        Set set = null;
        ServiceSchemaManager serviceSchemaManager = null;
        ServiceSchema serviceSchema = null;
        try {
            serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMUserService");
            if (serviceSchemaManager != null) {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
                set = serviceSchema.getAttributeSchemaNames();
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMUserNavModelImpl.getUserSearchAttribute", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserNavModelImpl.getUserSearchAttribute", (Throwable)sSOException);
        }
        if (set == null) {
            return new HashMap(0);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string2);
            if (attributeSchema == null || (string = attributeSchema.getI18NKey()) == null || string.length() == 0) continue;
            hashMap.put(string2, this.getL10NAttributeName(serviceSchemaManager, string));
        }
        return hashMap;
    }

    private String getSearchFilter(String string, String string2) throws SSOException {
        String string3 = this.getUserSearchAttribute(string);
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("(").append(string3).append("=").append(string2).append(")");
        return stringBuffer.toString();
    }

    private String getUserSearchAttribute(String string) {
        String string2 = null;
        try {
            AMTemplate aMTemplate = this.getOrgTemplate(string);
            if (aMTemplate != null) {
                string2 = AMAdminUtils.getStringAttribute(aMTemplate, "iplanet-am-admin-console-user-search-key");
                if (AMModelBase.debug.messageEnabled()) {
                    AMModelBase.debug.message("UMUserNavModelImpl.getUserSearchAttribute():obtained from org template " + string2);
                }
            } else {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager("iPlanetAMAdminConsoleService");
                if (serviceSchemaManager != null) {
                    string2 = AMAdminUtils.getStringAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "iplanet-am-admin-console-user-search-key");
                    if (AMModelBase.debug.messageEnabled()) {
                        AMModelBase.debug.message("UMUserNavModelImpl.getUserSearchAttribute:obtained from schema " + string2);
                    }
                }
            }
        }
        catch (SMSException sMSException) {
            AMModelBase.debug.warning("UMUserNavModelImpl.getUserSearchAttribute", (Throwable)sMSException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserNavModelImpl.getUserSearchAttribute", (Throwable)sSOException);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserNavModelImpl.getUserSearchAttribute", (Throwable)aMException);
        }
        if (string2 == null) {
            string2 = AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug);
        }
        return string2;
    }

    protected List getValidatedAttributes(String string, String string2, int n, String string3) {
        List list;
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        if (string != null && string.length() > 0 && (list = this.getObjectDisplayList(string, "users")) != null && !list.isEmpty()) {
            arrayList = new ArrayList(list.size());
            Set set = this.getUserAttributeNames();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (!set.contains(string4) || arrayList.contains(string4)) continue;
                    arrayList.add(string4);
                }
            }
        }
        if (arrayList == null || arrayList.isEmpty()) {
            arrayList = new ArrayList<String>(1);
            arrayList.add(AdminInterfaceUtils.getNamingAttribute((int)1, (Debug)AMModelBase.debug));
        }
        return arrayList;
    }

    private AMPeopleContainer getDefaultPeopleContainer() {
        AMPeopleContainer aMPeopleContainer = null;
        Set set = Collections.EMPTY_SET;
        try {
            Iterator iterator;
            String string = AdminInterfaceUtils.getNamingAttribute((int)5, (Debug)AMModelBase.debug);
            switch (this.locationType) {
                case 2: {
                    AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
                    aMPeopleContainer = this.dpStoreConn.getPeopleContainer(string + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + aMOrganization.getDN());
                    if (aMPeopleContainer != null && aMPeopleContainer.isExists()) break;
                    set = aMOrganization.getPeopleContainers(1);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
                    aMPeopleContainer = this.dpStoreConn.getPeopleContainer(string + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + aMOrganizationalUnit.getDN());
                    if (aMPeopleContainer != null && aMPeopleContainer.isExists()) break;
                    set = aMOrganizationalUnit.getPeopleContainers(1);
                    break;
                }
                default: {
                    AMModelBase.debug.warning("Unsupported object type for people containers");
                }
            }
            if (!set.isEmpty() && (iterator = set.iterator()).hasNext()) {
                aMPeopleContainer = this.dpStoreConn.getPeopleContainer((String)iterator.next());
            }
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMUserNavModelImpl.getDefaultPeopleContainer", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMUserNavModelImpl.getDefaultPeopleContainer", (Throwable)sSOException);
        }
        return aMPeopleContainer;
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("users.header");
    }

    public String getNoEntrySelectedForDelTitle() {
        return this.getLocalizedString("noUserSelectForDeletion.title");
    }

    public String getNoEntrySelectedForDelMessage() {
        return this.getLocalizedString("noUserSelectForDeletion.message");
    }

    public Set getAttrList() {
        return this.users;
    }

    public void setAttrList(Set set) {
        this.setUsers(set);
    }

    private void writeLog(String string, String string2, Set set) {
        if (this.logger.isEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(this.getLocalizedString(string)).append(" " + string2).append(":" + set);
            this.logger.doLog(stringBuffer.toString());
        }
    }

    public String getUsersDisplayOffMessage() {
        return this.getLocalizedString("usersDisplayOff.message");
    }

    protected boolean isCurrentLocationTypeValid() {
        boolean bl = false;
        switch (this.locationType) {
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                bl = true;
                break;
            }
            default: {
                if (!AMModelBase.debug.warningEnabled()) break;
                AMModelBase.debug.warning("UMUserNavModelImpl.isCurrentLocationTypeValid: invalid location type, " + this.locationType);
            }
        }
        return bl;
    }

    public String getAttributeValue(String string) {
        this.getSearchReturnAttributes();
        if (this.searchReturnAttrs.isEmpty()) {
            return AMFormatUtils.DNToName(this, string, true);
        }
        int n = this.searchReturnAttrs.size();
        return this.getAttributeValue(string, (String)this.searchReturnAttrs.get(n - 1));
    }
}

