/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMFormatUtils;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.settings.Setting;
import com.iplanet.am.console.user.model.UMUserGroupSelectModel;
import com.iplanet.am.console.user.model.UMUserViewModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.util.DN;

public class UMUserGroupSelectModelImpl
extends UMUserViewModelImpl
implements UMUserGroupSelectModel {
    private Set groups = null;
    private boolean groupsModified = false;
    private Set userGroups = null;

    public UMUserGroupSelectModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, map);
        this.getUserGroupDNs();
    }

    public void removeGroups(Set set) throws AMConsoleException {
        if (this.curUser == null || set == null) {
            return;
        }
        AMStoreConnection aMStoreConnection = null;
        if (!this.isAdministrator()) {
            aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (SecurityException securityException) {
                        AMModelBase.debug.error("UMUserGroupSelectModelImpl.updateGroups", (Throwable)securityException);
                        return null;
                    }
                }
            });
        }
        if (aMStoreConnection == null) {
            aMStoreConnection = this.dpStoreConn;
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        AMUser aMUser = this.curUser;
        try {
            aMUser = aMStoreConnection.getUser(this.curUser.getDN());
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMUserGroupSelectModelImpl.updateGroups", (Throwable)sSOException);
            arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
        }
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    int n = this.getObjectType(string);
                    if (n == 9 || n == 10) {
                        aMUser.removeStaticGroup(string);
                    } else {
                        aMUser.removeAssignableDynamicGroup(string);
                    }
                    this.groupsModified = true;
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append(this.getLocalizedString("removedUserFromGroup.message")).append(" " + string).append(":[" + this.curUser.getDN() + "]");
                    this.logger.doLog(stringBuffer.toString());
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("removing groups from user", (Throwable)aMException);
                    arrayList.add(this.getErrorString((Exception)((Object)aMException)));
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("removing groups from user", (Throwable)sSOException);
                    arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
                }
            }
        }
        if (!arrayList.isEmpty()) {
            throw new AMConsoleException(arrayList);
        }
    }

    public Set getGroups(String string) {
        if (!this.getShowUserGroupFlag()) {
            return Collections.EMPTY_SET;
        }
        if (this.groups == null) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(this.getUserGroupDNs());
            if (!this.getUserGroupSubscribe()) {
                this.groups = this.convertToOrderedSet(hashSet);
                return this.groups;
            }
            HashMap hashMap = new HashMap(1);
            HashSet<String> hashSet2 = new HashSet<String>(1);
            if (this.isAdministrator() && this.canPerform(Setting.ACTION_GROUP, "modifyproperties")) {
                hashSet2.add("*");
            } else {
                hashSet2.add("true");
            }
            hashMap.put("iplanet-am-group-subscribable", hashSet2);
            AMOrganization aMOrganization = this.getUserOrg();
            if (aMOrganization != null) {
                Set set = null;
                try {
                    Set set2 = aMOrganization.getGroupContainers(1);
                    set = set2 == null || set2.isEmpty() ? this.getGroupsInOrg(aMOrganization, hashMap, string) : this.getGroupsInContainers(set2, hashMap, string);
                    if (set != null && !this.isAdminGroupsEnabled()) {
                        set = this.removeHiddenGroups(set);
                    }
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("UMUserGroupSelectModelImpl.getGroups", (Throwable)sSOException);
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("UMUserGroupSelectModelImpl.getGroups", (Throwable)aMException);
                }
                if (hashSet == null || hashSet.isEmpty()) {
                    hashSet = set;
                } else {
                    this.combineGroups(hashSet, set);
                }
            }
            this.groups = this.convertToOrderedSet(hashSet);
        }
        return this.groups;
    }

    public String getGroupDisplayName(String string) {
        return AMFormatUtils.DNToName(this, string);
    }

    public String getNoGroupTitle() {
        return this.getLocalizedString("nosubscribablegroups.title");
    }

    public String getNoGroupMessage() {
        return this.getLocalizedString("nosubscribablegroups.message");
    }

    public String getNoGroupsAvailableMsg() {
        return this.getLocalizedString("noAddGroupEntries.message");
    }

    public Set getUserGroupDNs() {
        if (this.curUser != null) {
            try {
                this.userGroups = this.curUser.getStaticGroupDNs();
                this.userGroups.addAll(this.curUser.getAssignableDynamicGroupDNs());
            }
            catch (AMException aMException) {
                AMModelBase.debug.warning("UMUserGroupSelectModelImpl.getUserGroupDNs", (Throwable)aMException);
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.error("UMUserGroupSelectModelImpl.getUserGroupDNs", (Throwable)sSOException);
            }
        }
        if (!this.isAdminGroupsEnabled()) {
            this.userGroups = this.removeHiddenGroups(this.userGroups);
        }
        if (this.userGroups == null) {
            this.userGroups = Collections.EMPTY_SET;
        }
        return this.userGroups;
    }

    private Set getGroupsInOrg(AMOrganization aMOrganization, Map map, String string) throws AMException, SSOException {
        Set set = this.searchGroups(aMOrganization, string, map, 1);
        HashSet hashSet = new HashSet(25);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                AMGroup aMGroup = this.getGroupObjectByDN(string2);
                if (aMGroup == null) continue;
                hashSet.addAll(aMGroup.searchGroups("*", map, 2));
            }
        }
        return hashSet;
    }

    private Set getGroupsInContainers(Set set, Map map, String string) throws AMException, SSOException {
        AMStoreConnection aMStoreConnection = null;
        if (!this.isAdministrator()) {
            aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (SecurityException securityException) {
                        AMModelBase.debug.error("UMUserGroupSelectModelImpl.getGroupsInContainers", (Throwable)securityException);
                        return null;
                    }
                }
            });
        }
        if (aMStoreConnection == null) {
            aMStoreConnection = this.dpStoreConn;
        }
        HashSet hashSet = new HashSet(25);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMGroupContainer aMGroupContainer = aMStoreConnection.getGroupContainer((String)iterator.next());
            hashSet.addAll(aMGroupContainer.searchGroups(string, map, 2));
        }
        return hashSet;
    }

    private Set searchGroups(AMOrganization aMOrganization, String string, Map map, int n) throws AMException, SSOException {
        Set set = aMOrganization.searchStaticGroups(string, map, n);
        set.addAll(aMOrganization.searchAssignableDynamicGroups(string, map, n));
        return set;
    }

    private AMGroup getGroupObjectByDN(String string) throws AMException, SSOException {
        AMStaticGroup aMStaticGroup = null;
        AMStoreConnection aMStoreConnection = null;
        if (!this.isAdministrator()) {
            aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (SecurityException securityException) {
                        AMModelBase.debug.error("UMUserGroupSelectModelImpl.getGroupObjectByDN", (Throwable)securityException);
                        return null;
                    }
                }
            });
        }
        if (aMStoreConnection == null) {
            aMStoreConnection = this.dpStoreConn;
        }
        int n = aMStoreConnection.getAMObjectType(string);
        switch (n) {
            case 9: 
            case 10: {
                aMStaticGroup = aMStoreConnection.getStaticGroup(string);
                break;
            }
            case 11: {
                aMStaticGroup = aMStoreConnection.getDynamicGroup(string);
                break;
            }
            default: {
                aMStaticGroup = aMStoreConnection.getAssignableDynamicGroup(string);
            }
        }
        return aMStaticGroup;
    }

    private Set removeHiddenGroups(Set set) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (set != null && !set.isEmpty()) {
            hashSet = new HashSet<String>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = AMFormatUtils.DNToName(this, string);
                if (string2.equalsIgnoreCase("DomainAdministrators") || string2.equalsIgnoreCase("DomainHelpDeskAdministrators") || string2.equalsIgnoreCase("ServiceAdministrators") || string2.equalsIgnoreCase("ServiceHelpDeskAdministrators")) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private void combineGroups(Set set, Set set2) {
        if (set2 == null || set2.isEmpty() || set == null) {
            return;
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            String string = (String)iterator.next();
            DN dN = new DN(string);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext() && !bl) {
                String string2 = (String)iterator2.next();
                DN dN2 = new DN(string2);
                bl = dN.equals(dN2);
            }
            if (bl) continue;
            set.add(string);
        }
    }

    public String getHeaderLabel() {
        return this.getLocalizedString("groups.header");
    }

    public String getSuccessMessage() {
        if (this.groupsModified) {
            return this.getLocalizedString("updateUser.message");
        }
        return this.getLocalizedString("noChangesMade.message");
    }

    public String getAddButtonLabel() {
        return this.getLocalizedString("dynGUIAddToList.button");
    }

    public String getRemoveButtonLabel() {
        return this.getLocalizedString("dynGUIRemoveFromList.button");
    }

    public Set getAssignedGroups() {
        return this.getUserGroupDNs();
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("userGroups.help");
        if (string.equals("userGroups.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getGroupNotSelectedMessage() {
        return this.getLocalizedString("groupNotSelected.message");
    }

    public String getGroupNotSelectedTitle() {
        return this.getLocalizedString("groupNotSelected.title");
    }

    public Set getUnAssignedGroups(String string) {
        Set set = this.excludedObjFromSet(this.getGroups(string), this.getUserGroupDNs());
        return set == null ? Collections.EMPTY_SET : set;
    }

    public void updateGroups(Set set) throws AMConsoleException {
        if (this.curUser == null || !this.isAdministrator() && !this.getUserGroupSubscribe()) {
            AMModelBase.debug.warning("User has no permission to update the groups.");
            return;
        }
        Set set2 = this.getUserGroupDNs();
        Set set3 = this.excludedObjFromSet(set2, set);
        Set set4 = this.excludedObjFromSet(set, set2);
        this.removeGroups(set3);
        this.addGroups(set4);
    }

    public void addGroups(Set set) throws AMConsoleException {
        this.setAttrList(null);
        if (this.curUser == null || set == null) {
            return;
        }
        Set set2 = this.getUserGroupDNs();
        if (set2.equals(set)) {
            return;
        }
        AMStoreConnection aMStoreConnection = null;
        if (!this.isAdministrator()) {
            aMStoreConnection = (AMStoreConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return AMAdminUtils.getStoreConnAsAdmin();
                    }
                    catch (SecurityException securityException) {
                        AMModelBase.debug.error("UMUserGroupSelectModelImpl.addGroups", (Throwable)securityException);
                        return null;
                    }
                }
            });
        }
        if (aMStoreConnection == null) {
            aMStoreConnection = this.dpStoreConn;
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        AMUser aMUser = this.curUser;
        try {
            aMUser = aMStoreConnection.getUser(this.curUser.getDN());
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.error("UMUserGroupSelectModelImpl.addGroups", (Throwable)sSOException);
            arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
        }
        Set set3 = this.excludedObjFromSet(set, set2);
        if (set3 != null && !set3.isEmpty()) {
            Iterator iterator = set3.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    int n = this.getObjectType(string);
                    if (n == 9 || n == 10) {
                        aMUser.assignStaticGroup(string);
                    } else {
                        aMUser.assignAssignableDynamicGroup(string);
                    }
                    this.groupsModified = true;
                    StringBuffer stringBuffer = new StringBuffer(100);
                    stringBuffer.append(this.getLocalizedString("assignedUserToGroup.message")).append(" " + string).append(":[" + this.curUser.getDN() + "]");
                    this.logger.doLog(stringBuffer.toString());
                }
                catch (AMException aMException) {
                    AMModelBase.debug.warning("assigning groups to user", (Throwable)aMException);
                    arrayList.add(this.getErrorString((Exception)((Object)aMException)));
                }
                catch (SSOException sSOException) {
                    AMModelBase.debug.error("assigning groups to user", (Throwable)sSOException);
                    arrayList.add(this.getErrorString((Exception)((Object)sSOException)));
                }
            }
        }
        if (!arrayList.isEmpty()) {
            throw new AMConsoleException(arrayList);
        }
    }

    public String getDisplayGroupsMessage() {
        return this.getLocalizedString("displayGroups.message");
    }

    public String getDisplayEndUserGroupsLabel() {
        return this.getLocalizedString("displayEndUserGroups.label");
    }

    public String getNoGroupsAssignedMessage() {
        return this.getLocalizedString("noGroupsAssigned.message");
    }
}

