/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.user.model;

import com.iplanet.am.console.base.model.AMAdminUtils;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.base.model.AMServiceDisplayModelImpl;
import com.iplanet.am.console.base.model.AMSystemConfig;
import com.iplanet.am.console.service.model.SMNavModelImpl;
import com.iplanet.am.console.user.model.UMCreateSvcTemplateModel;
import com.iplanet.am.console.user.model.UMCreateSvcTemplateModelImpl;
import com.iplanet.am.console.user.model.UMServiceRegModel;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMServiceRegModelImpl
extends SMNavModelImpl
implements UMServiceRegModel {
    private List errorMessage = Collections.EMPTY_LIST;
    private boolean hasUnRegisteredServices = false;
    private UMCreateSvcTemplateModel templateModel = null;

    public UMServiceRegModelImpl(HttpServletRequest httpServletRequest, Map map) {
        super(httpServletRequest, "amAdminModuleMsgs", map);
        this.templateModel = new UMCreateSvcTemplateModelImpl(httpServletRequest, map);
        this.listServices(null);
    }

    public boolean hasUnRegisteredServices() {
        return this.hasUnRegisteredServices;
    }

    public List getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorTitle() {
        return this.getLocalizedString("errorMessage.title");
    }

    public String getTableTitle() {
        return this.getLocalizedString("addServicesTable.title");
    }

    public String getTitle() {
        return this.getLocalizedString("registerServices.title");
    }

    public String getNameLabel() {
        return this.getLocalizedString("name.label");
    }

    public String getSubmitButtonLabel() {
        return this.getLocalizedString("register.button");
    }

    public String getNoServiceMessage() {
        return this.getLocalizedString("allServicesRegistered.message");
    }

    public void listServices(Set set) {
        Set set2 = this.getHierarchy();
        Set set3 = this.getSvcsForRegistration(set);
        Set set4 = Collections.EMPTY_SET;
        try {
            set4 = this.dpStoreConn.getServiceNames();
        }
        catch (AMException aMException) {
            AMModelBase.debug.error("UMServiceRegModelImpl.listServices, ", (Throwable)aMException);
        }
        if (!set3.isEmpty()) {
            Map map = this.buildLocalizedLookup(set2, set4);
            this.process(set2, set3, map);
        } else {
            this.rowNodes = Collections.EMPTY_LIST;
        }
        this.hasUnRegisteredServices = this.getSize() > 0;
    }

    private Set getSvcsForRegistration(Set set) {
        Object object;
        Object object2;
        Set set2 = Collections.EMPTY_SET;
        String string = AMSystemConfig.rootSuffix;
        try {
            set2 = this.locationDN.equalsIgnoreCase(string) || AMAdminUtils.getParent(this.locationDN).equalsIgnoreCase(string) && !string.equalsIgnoreCase(AMSystemConfig.defaultOrg) ? this.dpStoreConn.getServiceNames() : this.getServiceList(AMAdminUtils.getParent(this.locationDN));
            object2 = new AMServiceDisplayModelImpl(this.dpStoreConn);
            object = object2.getDeniedServices(this.dpUser);
            set2.removeAll((Collection<?>)object);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMServiceRegModelImpl:getSvcsForRegistration", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMServiceRegModelImpl:getSvcsForRegistration", (Throwable)sSOException);
        }
        this.discardRegisteredServices(set2);
        if (set2.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        object2 = new HashSet(set2.size());
        object = set2.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            try {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(string2);
                Set set3 = serviceSchemaManager.getSchemaTypes();
                Iterator iterator = set3.iterator();
                while (iterator.hasNext()) {
                    SchemaType schemaType = (SchemaType)iterator.next();
                    if (!schemaType.equals((Object)SchemaType.DYNAMIC) && !schemaType.equals((Object)SchemaType.ORGANIZATION) && !schemaType.equals((Object)SchemaType.POLICY) && !schemaType.equals((Object)SchemaType.USER)) continue;
                    object2.add(string2);
                }
            }
            catch (SSOException sSOException) {
                AMModelBase.debug.warning("UMServiceRegModelImpl getSvcsForRegistration", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                AMModelBase.debug.error("UMServiceRegModelImpl getSvcsForRegistration", (Throwable)sMSException);
            }
        }
        if (set != null && !set.isEmpty()) {
            object2.removeAll(set);
        }
        return object2;
    }

    private void discardRegisteredServices(Set set) {
        Set set2 = this.getRegisteredServices();
        HashSet<String> hashSet = new HashSet<String>(set2.size() * 2);
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("available services = " + set);
            AMModelBase.debug.message("registered services = " + set2);
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            hashSet.add(((String)iterator.next()).toLowerCase());
        }
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            if (!hashSet.contains(string.toLowerCase())) continue;
            iterator2.remove();
        }
    }

    private Set getRegisteredServices() {
        Set set = Collections.EMPTY_SET;
        try {
            set = this.getServiceList(this.locationDN);
        }
        catch (AMException aMException) {
            AMModelBase.debug.warning("UMServiceRegModelImpl:getRegisteredServices", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            AMModelBase.debug.warning("UMServiceRegModelImpl:getRegisteredServices", (Throwable)sSOException);
        }
        if (AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.message("UMServiceNavModelImpl:getRegisteredServices" + set);
        }
        return set;
    }

    public boolean registerServices(Set set) {
        boolean bl = true;
        if (set != null && !set.isEmpty()) {
            if (this.locationType == 2) {
                bl = this.registerServicesInOrg(set);
            } else if (this.locationType == 3) {
                bl = this.registerServicesInOrgUnit(set);
            } else {
                AMModelBase.debug.error("UMServiceRegModelImpl:RegisterServices invalid object type.");
            }
        }
        return bl;
    }

    private boolean registerServicesInOrg(Set set) {
        boolean bl = true;
        int n = set.size();
        HashSet<String> hashSet = new HashSet<String>(n * 2);
        this.errorMessage = new ArrayList(n);
        try {
            AMOrganization aMOrganization = this.dpStoreConn.getOrganization(this.locationDN);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    aMOrganization.registerService(string, false, false);
                    try {
                        this.templateModel.createServiceTemplate(string);
                    }
                    catch (AMConsoleException aMConsoleException) {
                        AMModelBase.debug.error("couldn't create the template for " + string, (Throwable)aMConsoleException);
                    }
                    this.writeFormatLog("service.registered", string, this.locationDN);
                    hashSet.add(string);
                }
                catch (AMException aMException) {
                    this.handleRegistrationException("UMServiceRegModelImpl:registerServicesInOrg", string, (Exception)((Object)aMException));
                    bl = false;
                }
                catch (SSOException sSOException) {
                    this.handleRegistrationException("UMServiceRegModelImpl:registerServicesInOrg", string, (Exception)((Object)sSOException));
                    bl = false;
                }
            }
        }
        catch (SSOException sSOException) {
            this.handleRegistrationException("UMServiceRegModelImpl:registerServicesInOrg", "", (Exception)((Object)sSOException));
            bl = false;
        }
        this.listServices(hashSet);
        return bl;
    }

    private boolean registerServicesInOrgUnit(Set set) {
        boolean bl = true;
        int n = set.size();
        HashSet<String> hashSet = new HashSet<String>(n * 2);
        this.errorMessage = new ArrayList(n);
        try {
            AMOrganizationalUnit aMOrganizationalUnit = this.dpStoreConn.getOrganizationalUnit(this.locationDN);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    aMOrganizationalUnit.registerService(string, false, false);
                    this.writeFormatLog("service.registered", string, this.locationDN);
                    hashSet.add(string);
                }
                catch (AMException aMException) {
                    this.handleRegistrationException("UMServiceRegModelImpl:registerServicesInOrgUnit", string, (Exception)((Object)aMException));
                    bl = false;
                }
                catch (SSOException sSOException) {
                    this.handleRegistrationException("UMServiceRegModelImpl:registerServicesInOrgUnit", string, (Exception)((Object)sSOException));
                    bl = false;
                }
            }
        }
        catch (SSOException sSOException) {
            this.handleRegistrationException("UMServiceRegModelImpl:registerServicesInOrgUnit", "", (Exception)((Object)sSOException));
            bl = false;
        }
        this.listServices(hashSet);
        return bl;
    }

    private void handleRegistrationException(String string, String string2, Exception exception) {
        if (AMModelBase.debug.warningEnabled()) {
            AMModelBase.debug.warning(string + " failed to register service " + string2, (Throwable)exception);
        }
        if (string2.length() > 0) {
            this.errorMessage.add(this.getLocalizedServiceName(string2) + ": " + this.getErrorString(exception));
        } else {
            this.errorMessage.add(this.getErrorString(exception));
        }
    }

    public String getNoEntrySelectedForRegTitle() {
        return this.getLocalizedString("noSvcSelectForRegistration.title");
    }

    public String getNoEntrySelectedForRegMessage() {
        return this.getLocalizedString("noSvcSelectForRegistration.message");
    }

    public String getHelpAnchorTag() {
        String string = this.getLocalizedString("serviceRegistration.help");
        if (string.equals("serviceRegistration.help")) {
            string = "contents.html";
        }
        return this.getHelpURL(string);
    }

    public String getCannotRegisterServiceMessage() {
        return this.getLocalizedString("registerServicesFailed.message");
    }
}

